// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The AzureOpenAITokenizerParameters model.
 */
@Fluent
public final class AzureOpenAITokenizerParameters implements JsonSerializable<AzureOpenAITokenizerParameters> {
    /*
     * Only applies if the unit is set to azureOpenAITokens. Options include 'R50k_base', 'P50k_base', 'P50k_edit' and
     * 'CL100k_base'. The default value is 'CL100k_base'.
     */
    @Generated
    private SplitSkillEncoderModelName encoderModelName;

    /*
     * (Optional) Only applies if the unit is set to azureOpenAITokens. This parameter defines a collection of special
     * tokens that are permitted within the tokenization process.
     */
    @Generated
    private List<String> allowedSpecialTokens;

    /**
     * Creates an instance of AzureOpenAITokenizerParameters class.
     */
    @Generated
    public AzureOpenAITokenizerParameters() {
    }

    /**
     * Get the encoderModelName property: Only applies if the unit is set to azureOpenAITokens. Options include
     * 'R50k_base', 'P50k_base', 'P50k_edit' and 'CL100k_base'. The default value is 'CL100k_base'.
     * 
     * @return the encoderModelName value.
     */
    @Generated
    public SplitSkillEncoderModelName getEncoderModelName() {
        return this.encoderModelName;
    }

    /**
     * Set the encoderModelName property: Only applies if the unit is set to azureOpenAITokens. Options include
     * 'R50k_base', 'P50k_base', 'P50k_edit' and 'CL100k_base'. The default value is 'CL100k_base'.
     * 
     * @param encoderModelName the encoderModelName value to set.
     * @return the AzureOpenAITokenizerParameters object itself.
     */
    @Generated
    public AzureOpenAITokenizerParameters setEncoderModelName(SplitSkillEncoderModelName encoderModelName) {
        this.encoderModelName = encoderModelName;
        return this;
    }

    /**
     * Get the allowedSpecialTokens property: (Optional) Only applies if the unit is set to azureOpenAITokens. This
     * parameter defines a collection of special tokens that are permitted within the tokenization process.
     * 
     * @return the allowedSpecialTokens value.
     */
    @Generated
    public List<String> getAllowedSpecialTokens() {
        return this.allowedSpecialTokens;
    }

    /**
     * Set the allowedSpecialTokens property: (Optional) Only applies if the unit is set to azureOpenAITokens. This
     * parameter defines a collection of special tokens that are permitted within the tokenization process.
     * 
     * @param allowedSpecialTokens the allowedSpecialTokens value to set.
     * @return the AzureOpenAITokenizerParameters object itself.
     */
    @Generated
    public AzureOpenAITokenizerParameters setAllowedSpecialTokens(List<String> allowedSpecialTokens) {
        this.allowedSpecialTokens = allowedSpecialTokens;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("encoderModelName",
            this.encoderModelName == null ? null : this.encoderModelName.toString());
        jsonWriter.writeArrayField("allowedSpecialTokens", this.allowedSpecialTokens,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureOpenAITokenizerParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureOpenAITokenizerParameters if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AzureOpenAITokenizerParameters.
     */
    @Generated
    public static AzureOpenAITokenizerParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureOpenAITokenizerParameters deserializedAzureOpenAITokenizerParameters
                = new AzureOpenAITokenizerParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("encoderModelName".equals(fieldName)) {
                    deserializedAzureOpenAITokenizerParameters.encoderModelName
                        = SplitSkillEncoderModelName.fromString(reader.getString());
                } else if ("allowedSpecialTokens".equals(fieldName)) {
                    List<String> allowedSpecialTokens = reader.readArray(reader1 -> reader1.getString());
                    deserializedAzureOpenAITokenizerParameters.allowedSpecialTokens = allowedSpecialTokens;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAzureOpenAITokenizerParameters;
        });
    }
}
