// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Specifies how 'extraParameters' should be handled by Azure AI Foundry. Defaults to 'error'.
 */
public final class ChatCompletionExtraParametersBehavior
    extends ExpandableStringEnum<ChatCompletionExtraParametersBehavior> {
    /**
     * Passes any extra parameters directly to the model.
     */
    @Generated
    public static final ChatCompletionExtraParametersBehavior PASS_THROUGH = fromString("passThrough");

    /**
     * Drops all extra parameters.
     */
    @Generated
    public static final ChatCompletionExtraParametersBehavior DROP = fromString("drop");

    /**
     * Raises an error if any extra parameter is present.
     */
    @Generated
    public static final ChatCompletionExtraParametersBehavior ERROR = fromString("error");

    /**
     * Creates a new instance of ChatCompletionExtraParametersBehavior value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public ChatCompletionExtraParametersBehavior() {
    }

    /**
     * Creates or finds a ChatCompletionExtraParametersBehavior from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ChatCompletionExtraParametersBehavior.
     */
    @Generated
    public static ChatCompletionExtraParametersBehavior fromString(String name) {
        return fromString(name, ChatCompletionExtraParametersBehavior.class);
    }

    /**
     * Gets known ChatCompletionExtraParametersBehavior values.
     * 
     * @return known ChatCompletionExtraParametersBehavior values.
     */
    @Generated
    public static Collection<ChatCompletionExtraParametersBehavior> values() {
        return values(ChatCompletionExtraParametersBehavior.class);
    }
}
