// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * A skill that calls a language model via Azure AI Foundry's Chat Completions endpoint.
 */
@Fluent
public final class ChatCompletionSkill extends WebApiSkill {
    /*
     * A URI fragment specifying the type of skill.
     */
    @Generated
    private String odataType = "#Microsoft.Skills.Custom.ChatCompletionSkill";

    /*
     * API key for authenticating to the model. Both apiKey and authIdentity cannot be specified at the same time.
     */
    @Generated
    private String apiKey;

    /*
     * Common language model parameters that customers can tweak. If omitted, reasonable defaults will be applied.
     */
    @Generated
    private CommonModelParameters commonModelParameters;

    /*
     * Open-type dictionary for model-specific parameters that should be appended to the chat completions call. Follows
     * Azure AI Foundry’s extensibility pattern.
     */
    @Generated
    private Map<String, Object> extraParameters;

    /*
     * How extra parameters are handled by Azure AI Foundry. Default is 'error'.
     */
    @Generated
    private ChatCompletionExtraParametersBehavior extraParametersBehavior;

    /*
     * Determines how the LLM should format its response. Defaults to 'text' response type.
     */
    @Generated
    private ChatCompletionResponseFormat responseFormat;

    /**
     * Creates an instance of ChatCompletionSkill class.
     * 
     * @param inputs the inputs value to set.
     * @param outputs the outputs value to set.
     * @param uri the uri value to set.
     */
    @Generated
    public ChatCompletionSkill(List<InputFieldMappingEntry> inputs, List<OutputFieldMappingEntry> outputs, String uri) {
        super(inputs, outputs, uri);
    }

    /**
     * Get the odataType property: A URI fragment specifying the type of skill.
     * 
     * @return the odataType value.
     */
    @Generated
    @Override
    public String getOdataType() {
        return this.odataType;
    }

    /**
     * Get the apiKey property: API key for authenticating to the model. Both apiKey and authIdentity cannot be
     * specified at the same time.
     * 
     * @return the apiKey value.
     */
    @Generated
    public String getApiKey() {
        return this.apiKey;
    }

    /**
     * Set the apiKey property: API key for authenticating to the model. Both apiKey and authIdentity cannot be
     * specified at the same time.
     * 
     * @param apiKey the apiKey value to set.
     * @return the ChatCompletionSkill object itself.
     */
    @Generated
    public ChatCompletionSkill setApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    /**
     * Get the commonModelParameters property: Common language model parameters that customers can tweak. If omitted,
     * reasonable defaults will be applied.
     * 
     * @return the commonModelParameters value.
     */
    @Generated
    public CommonModelParameters getCommonModelParameters() {
        return this.commonModelParameters;
    }

    /**
     * Set the commonModelParameters property: Common language model parameters that customers can tweak. If omitted,
     * reasonable defaults will be applied.
     * 
     * @param commonModelParameters the commonModelParameters value to set.
     * @return the ChatCompletionSkill object itself.
     */
    @Generated
    public ChatCompletionSkill setCommonModelParameters(CommonModelParameters commonModelParameters) {
        this.commonModelParameters = commonModelParameters;
        return this;
    }

    /**
     * Get the extraParameters property: Open-type dictionary for model-specific parameters that should be appended to
     * the chat completions call. Follows Azure AI Foundry’s extensibility pattern.
     * 
     * @return the extraParameters value.
     */
    @Generated
    public Map<String, Object> getExtraParameters() {
        return this.extraParameters;
    }

    /**
     * Set the extraParameters property: Open-type dictionary for model-specific parameters that should be appended to
     * the chat completions call. Follows Azure AI Foundry’s extensibility pattern.
     * 
     * @param extraParameters the extraParameters value to set.
     * @return the ChatCompletionSkill object itself.
     */
    @Generated
    public ChatCompletionSkill setExtraParameters(Map<String, Object> extraParameters) {
        this.extraParameters = extraParameters;
        return this;
    }

    /**
     * Get the extraParametersBehavior property: How extra parameters are handled by Azure AI Foundry. Default is
     * 'error'.
     * 
     * @return the extraParametersBehavior value.
     */
    @Generated
    public ChatCompletionExtraParametersBehavior getExtraParametersBehavior() {
        return this.extraParametersBehavior;
    }

    /**
     * Set the extraParametersBehavior property: How extra parameters are handled by Azure AI Foundry. Default is
     * 'error'.
     * 
     * @param extraParametersBehavior the extraParametersBehavior value to set.
     * @return the ChatCompletionSkill object itself.
     */
    @Generated
    public ChatCompletionSkill
        setExtraParametersBehavior(ChatCompletionExtraParametersBehavior extraParametersBehavior) {
        this.extraParametersBehavior = extraParametersBehavior;
        return this;
    }

    /**
     * Get the responseFormat property: Determines how the LLM should format its response. Defaults to 'text' response
     * type.
     * 
     * @return the responseFormat value.
     */
    @Generated
    public ChatCompletionResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    /**
     * Set the responseFormat property: Determines how the LLM should format its response. Defaults to 'text' response
     * type.
     * 
     * @param responseFormat the responseFormat value to set.
     * @return the ChatCompletionSkill object itself.
     */
    @Generated
    public ChatCompletionSkill setResponseFormat(ChatCompletionResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public ChatCompletionSkill setHttpHeaders(Map<String, String> httpHeaders) {
        super.setHttpHeaders(httpHeaders);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public ChatCompletionSkill setHttpMethod(String httpMethod) {
        super.setHttpMethod(httpMethod);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public ChatCompletionSkill setTimeout(Duration timeout) {
        super.setTimeout(timeout);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public ChatCompletionSkill setBatchSize(Integer batchSize) {
        super.setBatchSize(batchSize);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public ChatCompletionSkill setDegreeOfParallelism(Integer degreeOfParallelism) {
        super.setDegreeOfParallelism(degreeOfParallelism);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public ChatCompletionSkill setAuthResourceId(String authResourceId) {
        super.setAuthResourceId(authResourceId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public ChatCompletionSkill setAuthIdentity(SearchIndexerDataIdentity authIdentity) {
        super.setAuthIdentity(authIdentity);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public ChatCompletionSkill setName(String name) {
        super.setName(name);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public ChatCompletionSkill setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public ChatCompletionSkill setContext(String context) {
        super.setContext(context);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("inputs", getInputs(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("outputs", getOutputs(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("uri", getUri());
        jsonWriter.writeStringField("name", getName());
        jsonWriter.writeStringField("description", getDescription());
        jsonWriter.writeStringField("context", getContext());
        jsonWriter.writeMapField("httpHeaders", getHttpHeaders(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("httpMethod", getHttpMethod());
        jsonWriter.writeStringField("timeout", CoreUtils.durationToStringWithDays(getTimeout()));
        jsonWriter.writeNumberField("batchSize", getBatchSize());
        jsonWriter.writeNumberField("degreeOfParallelism", getDegreeOfParallelism());
        jsonWriter.writeStringField("authResourceId", getAuthResourceId());
        jsonWriter.writeJsonField("authIdentity", getAuthIdentity());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeStringField("apiKey", this.apiKey);
        jsonWriter.writeJsonField("commonModelParameters", this.commonModelParameters);
        jsonWriter.writeMapField("extraParameters", this.extraParameters,
            (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("extraParametersBehavior",
            this.extraParametersBehavior == null ? null : this.extraParametersBehavior.toString());
        jsonWriter.writeJsonField("responseFormat", this.responseFormat);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ChatCompletionSkill from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ChatCompletionSkill if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ChatCompletionSkill.
     */
    @Generated
    public static ChatCompletionSkill fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean inputsFound = false;
            List<InputFieldMappingEntry> inputs = null;
            boolean outputsFound = false;
            List<OutputFieldMappingEntry> outputs = null;
            boolean uriFound = false;
            String uri = null;
            String name = null;
            String description = null;
            String context = null;
            Map<String, String> httpHeaders = null;
            String httpMethod = null;
            Duration timeout = null;
            Integer batchSize = null;
            Integer degreeOfParallelism = null;
            String authResourceId = null;
            SearchIndexerDataIdentity authIdentity = null;
            String odataType = "#Microsoft.Skills.Custom.ChatCompletionSkill";
            String apiKey = null;
            CommonModelParameters commonModelParameters = null;
            Map<String, Object> extraParameters = null;
            ChatCompletionExtraParametersBehavior extraParametersBehavior = null;
            ChatCompletionResponseFormat responseFormat = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("inputs".equals(fieldName)) {
                    inputs = reader.readArray(reader1 -> InputFieldMappingEntry.fromJson(reader1));
                    inputsFound = true;
                } else if ("outputs".equals(fieldName)) {
                    outputs = reader.readArray(reader1 -> OutputFieldMappingEntry.fromJson(reader1));
                    outputsFound = true;
                } else if ("uri".equals(fieldName)) {
                    uri = reader.getString();
                    uriFound = true;
                } else if ("name".equals(fieldName)) {
                    name = reader.getString();
                } else if ("description".equals(fieldName)) {
                    description = reader.getString();
                } else if ("context".equals(fieldName)) {
                    context = reader.getString();
                } else if ("httpHeaders".equals(fieldName)) {
                    httpHeaders = reader.readMap(reader1 -> reader1.getString());
                } else if ("httpMethod".equals(fieldName)) {
                    httpMethod = reader.getString();
                } else if ("timeout".equals(fieldName)) {
                    timeout = reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                } else if ("batchSize".equals(fieldName)) {
                    batchSize = reader.getNullable(JsonReader::getInt);
                } else if ("degreeOfParallelism".equals(fieldName)) {
                    degreeOfParallelism = reader.getNullable(JsonReader::getInt);
                } else if ("authResourceId".equals(fieldName)) {
                    authResourceId = reader.getString();
                } else if ("authIdentity".equals(fieldName)) {
                    authIdentity = SearchIndexerDataIdentity.fromJson(reader);
                } else if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                } else if ("apiKey".equals(fieldName)) {
                    apiKey = reader.getString();
                } else if ("commonModelParameters".equals(fieldName)) {
                    commonModelParameters = CommonModelParameters.fromJson(reader);
                } else if ("extraParameters".equals(fieldName)) {
                    extraParameters = reader.readMap(reader1 -> reader1.readUntyped());
                } else if ("extraParametersBehavior".equals(fieldName)) {
                    extraParametersBehavior = ChatCompletionExtraParametersBehavior.fromString(reader.getString());
                } else if ("responseFormat".equals(fieldName)) {
                    responseFormat = ChatCompletionResponseFormat.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            if (inputsFound && outputsFound && uriFound) {
                ChatCompletionSkill deserializedChatCompletionSkill = new ChatCompletionSkill(inputs, outputs, uri);
                deserializedChatCompletionSkill.setName(name);
                deserializedChatCompletionSkill.setDescription(description);
                deserializedChatCompletionSkill.setContext(context);
                deserializedChatCompletionSkill.setHttpHeaders(httpHeaders);
                deserializedChatCompletionSkill.setHttpMethod(httpMethod);
                deserializedChatCompletionSkill.setTimeout(timeout);
                deserializedChatCompletionSkill.setBatchSize(batchSize);
                deserializedChatCompletionSkill.setDegreeOfParallelism(degreeOfParallelism);
                deserializedChatCompletionSkill.setAuthResourceId(authResourceId);
                deserializedChatCompletionSkill.setAuthIdentity(authIdentity);
                deserializedChatCompletionSkill.odataType = odataType;
                deserializedChatCompletionSkill.apiKey = apiKey;
                deserializedChatCompletionSkill.commonModelParameters = commonModelParameters;
                deserializedChatCompletionSkill.extraParameters = extraParameters;
                deserializedChatCompletionSkill.extraParametersBehavior = extraParametersBehavior;
                deserializedChatCompletionSkill.responseFormat = responseFormat;

                return deserializedChatCompletionSkill;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!inputsFound) {
                missingProperties.add("inputs");
            }
            if (!outputsFound) {
                missingProperties.add("outputs");
            }
            if (!uriFound) {
                missingProperties.add("uri");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
