// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The multi-region account key of an Azure AI service resource that's attached to a skillset.
 */
@Fluent
public final class CognitiveServicesAccountKey extends CognitiveServicesAccount {

    /*
     * A URI fragment specifying the type of Azure AI service resource attached to a skillset.
     */
    @Generated
    private String odataType = "#Microsoft.Azure.Search.CognitiveServicesByKey";

    /*
     * The key used to provision the Azure AI service resource attached to a skillset.
     */
    @Generated
    private String key;

    /**
     * Creates an instance of CognitiveServicesAccountKey class.
     *
     * @param key the key value to set.
     */
    @Generated
    public CognitiveServicesAccountKey(String key) {
        this.key = key;
    }

    /**
     * Get the odataType property: A URI fragment specifying the type of Azure AI service resource attached to a
     * skillset.
     *
     * @return the odataType value.
     */
    @Generated
    @Override
    public String getOdataType() {
        return this.odataType;
    }

    /**
     * Get the key property: The key used to provision the Azure AI service resource attached to a skillset.
     *
     * @return the key value.
     */
    @Generated
    public String getKey() {
        return this.key;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public CognitiveServicesAccountKey setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", getDescription());
        jsonWriter.writeStringField("key", this.key);
        jsonWriter.writeStringField("@odata.type", this.odataType);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CognitiveServicesAccountKey from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of CognitiveServicesAccountKey if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CognitiveServicesAccountKey.
     */
    @Generated
    public static CognitiveServicesAccountKey fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String description = null;
            boolean keyFound = false;
            String key = null;
            String odataType = "#Microsoft.Azure.Search.CognitiveServicesByKey";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                } else if ("key".equals(fieldName)) {
                    key = reader.getString();
                    keyFound = true;
                } else if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            if (keyFound) {
                CognitiveServicesAccountKey deserializedCognitiveServicesAccountKey
                    = new CognitiveServicesAccountKey(key);
                deserializedCognitiveServicesAccountKey.setDescription(description);
                deserializedCognitiveServicesAccountKey.odataType = odataType;
                return deserializedCognitiveServicesAccountKey;
            }
            throw new IllegalStateException("Missing required property: key");
        });
    }

    /**
     * Set the key property: The key used to provision the cognitive service resource attached to a skillset.
     *
     * @param key the key value to set.
     * @return the CognitiveServicesAccountKey object itself.
     */
    public CognitiveServicesAccountKey setKey(String key) {
        this.key = key;
        return this;
    }
}
