// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Common language model parameters for Chat Completions. If omitted, default values are used.
 */
@Fluent
public final class CommonModelParameters implements JsonSerializable<CommonModelParameters> {
    /*
     * The name of the model to use (e.g., 'gpt-4o', etc.). Default is null if not specified.
     */
    @Generated
    private String model;

    /*
     * A float in the range [-2,2] that reduces or increases likelihood of repeated tokens. Default is 0.
     */
    @Generated
    private Float frequencyPenalty;

    /*
     * A float in the range [-2,2] that penalizes new tokens based on their existing presence. Default is 0.
     */
    @Generated
    private Float presencePenalty;

    /*
     * Maximum number of tokens to generate.
     */
    @Generated
    private Integer maxTokens;

    /*
     * Sampling temperature. Default is 0.7.
     */
    @Generated
    private Float temperature;

    /*
     * Random seed for controlling deterministic outputs. If omitted, randomization is used.
     */
    @Generated
    private Integer seed;

    /*
     * List of stop sequences that will cut off text generation. Default is none.
     */
    @Generated
    private List<String> stop;

    /**
     * Creates an instance of CommonModelParameters class.
     */
    @Generated
    public CommonModelParameters() {
    }

    /**
     * Get the model property: The name of the model to use (e.g., 'gpt-4o', etc.). Default is null if not specified.
     * 
     * @return the model value.
     */
    @Generated
    public String getModel() {
        return this.model;
    }

    /**
     * Set the model property: The name of the model to use (e.g., 'gpt-4o', etc.). Default is null if not specified.
     * 
     * @param model the model value to set.
     * @return the CommonModelParameters object itself.
     */
    @Generated
    public CommonModelParameters setModel(String model) {
        this.model = model;
        return this;
    }

    /**
     * Get the frequencyPenalty property: A float in the range [-2,2] that reduces or increases likelihood of repeated
     * tokens. Default is 0.
     * 
     * @return the frequencyPenalty value.
     */
    @Generated
    public Float getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    /**
     * Set the frequencyPenalty property: A float in the range [-2,2] that reduces or increases likelihood of repeated
     * tokens. Default is 0.
     * 
     * @param frequencyPenalty the frequencyPenalty value to set.
     * @return the CommonModelParameters object itself.
     */
    @Generated
    public CommonModelParameters setFrequencyPenalty(Float frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
        return this;
    }

    /**
     * Get the presencePenalty property: A float in the range [-2,2] that penalizes new tokens based on their existing
     * presence. Default is 0.
     * 
     * @return the presencePenalty value.
     */
    @Generated
    public Float getPresencePenalty() {
        return this.presencePenalty;
    }

    /**
     * Set the presencePenalty property: A float in the range [-2,2] that penalizes new tokens based on their existing
     * presence. Default is 0.
     * 
     * @param presencePenalty the presencePenalty value to set.
     * @return the CommonModelParameters object itself.
     */
    @Generated
    public CommonModelParameters setPresencePenalty(Float presencePenalty) {
        this.presencePenalty = presencePenalty;
        return this;
    }

    /**
     * Get the maxTokens property: Maximum number of tokens to generate.
     * 
     * @return the maxTokens value.
     */
    @Generated
    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    /**
     * Set the maxTokens property: Maximum number of tokens to generate.
     * 
     * @param maxTokens the maxTokens value to set.
     * @return the CommonModelParameters object itself.
     */
    @Generated
    public CommonModelParameters setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
        return this;
    }

    /**
     * Get the temperature property: Sampling temperature. Default is 0.7.
     * 
     * @return the temperature value.
     */
    @Generated
    public Float getTemperature() {
        return this.temperature;
    }

    /**
     * Set the temperature property: Sampling temperature. Default is 0.7.
     * 
     * @param temperature the temperature value to set.
     * @return the CommonModelParameters object itself.
     */
    @Generated
    public CommonModelParameters setTemperature(Float temperature) {
        this.temperature = temperature;
        return this;
    }

    /**
     * Get the seed property: Random seed for controlling deterministic outputs. If omitted, randomization is used.
     * 
     * @return the seed value.
     */
    @Generated
    public Integer getSeed() {
        return this.seed;
    }

    /**
     * Set the seed property: Random seed for controlling deterministic outputs. If omitted, randomization is used.
     * 
     * @param seed the seed value to set.
     * @return the CommonModelParameters object itself.
     */
    @Generated
    public CommonModelParameters setSeed(Integer seed) {
        this.seed = seed;
        return this;
    }

    /**
     * Get the stop property: List of stop sequences that will cut off text generation. Default is none.
     * 
     * @return the stop value.
     */
    @Generated
    public List<String> getStop() {
        return this.stop;
    }

    /**
     * Set the stop property: List of stop sequences that will cut off text generation. Default is none.
     * 
     * @param stop the stop value to set.
     * @return the CommonModelParameters object itself.
     */
    @Generated
    public CommonModelParameters setStop(List<String> stop) {
        this.stop = stop;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("model", this.model);
        jsonWriter.writeNumberField("frequencyPenalty", this.frequencyPenalty);
        jsonWriter.writeNumberField("presencePenalty", this.presencePenalty);
        jsonWriter.writeNumberField("maxTokens", this.maxTokens);
        jsonWriter.writeNumberField("temperature", this.temperature);
        jsonWriter.writeNumberField("seed", this.seed);
        jsonWriter.writeArrayField("stop", this.stop, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CommonModelParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CommonModelParameters if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CommonModelParameters.
     */
    @Generated
    public static CommonModelParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CommonModelParameters deserializedCommonModelParameters = new CommonModelParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("model".equals(fieldName)) {
                    deserializedCommonModelParameters.model = reader.getString();
                } else if ("frequencyPenalty".equals(fieldName)) {
                    deserializedCommonModelParameters.frequencyPenalty = reader.getNullable(JsonReader::getFloat);
                } else if ("presencePenalty".equals(fieldName)) {
                    deserializedCommonModelParameters.presencePenalty = reader.getNullable(JsonReader::getFloat);
                } else if ("maxTokens".equals(fieldName)) {
                    deserializedCommonModelParameters.maxTokens = reader.getNullable(JsonReader::getInt);
                } else if ("temperature".equals(fieldName)) {
                    deserializedCommonModelParameters.temperature = reader.getNullable(JsonReader::getFloat);
                } else if ("seed".equals(fieldName)) {
                    deserializedCommonModelParameters.seed = reader.getNullable(JsonReader::getInt);
                } else if ("stop".equals(fieldName)) {
                    List<String> stop = reader.readArray(reader1 -> reader1.getString());
                    deserializedCommonModelParameters.stop = stop;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCommonModelParameters;
        });
    }
}
