// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Decomposes compound words found in many Germanic languages. This token filter is implemented using Apache Lucene.
 */
@Fluent
public final class DictionaryDecompounderTokenFilter extends TokenFilter {
    /*
     * A URI fragment specifying the type of token filter.
     */
    @Generated
    private String odataType = "#Microsoft.Azure.Search.DictionaryDecompounderTokenFilter";

    /*
     * The list of words to match against.
     */
    @Generated
    private final List<String> wordList;

    /*
     * The minimum word size. Only words longer than this get processed. Default is 5. Maximum is 300.
     */
    @Generated
    private Integer minWordSize;

    /*
     * The minimum subword size. Only subwords longer than this are outputted. Default is 2. Maximum is 300.
     */
    @Generated
    private Integer minSubwordSize;

    /*
     * The maximum subword size. Only subwords shorter than this are outputted. Default is 15. Maximum is 300.
     */
    @Generated
    private Integer maxSubwordSize;

    /*
     * A value indicating whether to add only the longest matching subword to the output. Default is false.
     */
    @Generated
    private Boolean onlyLongestMatched;

    /**
     * Creates an instance of DictionaryDecompounderTokenFilter class.
     * 
     * @param name the name value to set.
     * @param wordList the wordList value to set.
     */
    @Generated
    public DictionaryDecompounderTokenFilter(String name, List<String> wordList) {
        super(name);
        this.wordList = wordList;
    }

    /**
     * Get the odataType property: A URI fragment specifying the type of token filter.
     * 
     * @return the odataType value.
     */
    @Generated
    @Override
    public String getOdataType() {
        return this.odataType;
    }

    /**
     * Get the wordList property: The list of words to match against.
     * 
     * @return the wordList value.
     */
    @Generated
    public List<String> getWordList() {
        return this.wordList;
    }

    /**
     * Get the minWordSize property: The minimum word size. Only words longer than this get processed. Default is 5.
     * Maximum is 300.
     * 
     * @return the minWordSize value.
     */
    @Generated
    public Integer getMinWordSize() {
        return this.minWordSize;
    }

    /**
     * Set the minWordSize property: The minimum word size. Only words longer than this get processed. Default is 5.
     * Maximum is 300.
     * 
     * @param minWordSize the minWordSize value to set.
     * @return the DictionaryDecompounderTokenFilter object itself.
     */
    @Generated
    public DictionaryDecompounderTokenFilter setMinWordSize(Integer minWordSize) {
        this.minWordSize = minWordSize;
        return this;
    }

    /**
     * Get the minSubwordSize property: The minimum subword size. Only subwords longer than this are outputted. Default
     * is 2. Maximum is 300.
     * 
     * @return the minSubwordSize value.
     */
    @Generated
    public Integer getMinSubwordSize() {
        return this.minSubwordSize;
    }

    /**
     * Set the minSubwordSize property: The minimum subword size. Only subwords longer than this are outputted. Default
     * is 2. Maximum is 300.
     * 
     * @param minSubwordSize the minSubwordSize value to set.
     * @return the DictionaryDecompounderTokenFilter object itself.
     */
    @Generated
    public DictionaryDecompounderTokenFilter setMinSubwordSize(Integer minSubwordSize) {
        this.minSubwordSize = minSubwordSize;
        return this;
    }

    /**
     * Get the maxSubwordSize property: The maximum subword size. Only subwords shorter than this are outputted. Default
     * is 15. Maximum is 300.
     * 
     * @return the maxSubwordSize value.
     */
    @Generated
    public Integer getMaxSubwordSize() {
        return this.maxSubwordSize;
    }

    /**
     * Set the maxSubwordSize property: The maximum subword size. Only subwords shorter than this are outputted. Default
     * is 15. Maximum is 300.
     * 
     * @param maxSubwordSize the maxSubwordSize value to set.
     * @return the DictionaryDecompounderTokenFilter object itself.
     */
    @Generated
    public DictionaryDecompounderTokenFilter setMaxSubwordSize(Integer maxSubwordSize) {
        this.maxSubwordSize = maxSubwordSize;
        return this;
    }

    /**
     * Get the onlyLongestMatched property: A value indicating whether to add only the longest matching subword to the
     * output. Default is false.
     * 
     * @return the onlyLongestMatched value.
     */
    @Generated
    public Boolean isOnlyLongestMatched() {
        return this.onlyLongestMatched;
    }

    /**
     * Set the onlyLongestMatched property: A value indicating whether to add only the longest matching subword to the
     * output. Default is false.
     * 
     * @param onlyLongestMatched the onlyLongestMatched value to set.
     * @return the DictionaryDecompounderTokenFilter object itself.
     */
    @Generated
    public DictionaryDecompounderTokenFilter setOnlyLongestMatched(Boolean onlyLongestMatched) {
        this.onlyLongestMatched = onlyLongestMatched;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", getName());
        jsonWriter.writeArrayField("wordList", this.wordList, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeNumberField("minWordSize", this.minWordSize);
        jsonWriter.writeNumberField("minSubwordSize", this.minSubwordSize);
        jsonWriter.writeNumberField("maxSubwordSize", this.maxSubwordSize);
        jsonWriter.writeBooleanField("onlyLongestMatch", this.onlyLongestMatched);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DictionaryDecompounderTokenFilter from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DictionaryDecompounderTokenFilter if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DictionaryDecompounderTokenFilter.
     */
    @Generated
    public static DictionaryDecompounderTokenFilter fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            boolean wordListFound = false;
            List<String> wordList = null;
            String odataType = "#Microsoft.Azure.Search.DictionaryDecompounderTokenFilter";
            Integer minWordSize = null;
            Integer minSubwordSize = null;
            Integer maxSubwordSize = null;
            Boolean onlyLongestMatched = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                } else if ("wordList".equals(fieldName)) {
                    wordList = reader.readArray(reader1 -> reader1.getString());
                    wordListFound = true;
                } else if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                } else if ("minWordSize".equals(fieldName)) {
                    minWordSize = reader.getNullable(JsonReader::getInt);
                } else if ("minSubwordSize".equals(fieldName)) {
                    minSubwordSize = reader.getNullable(JsonReader::getInt);
                } else if ("maxSubwordSize".equals(fieldName)) {
                    maxSubwordSize = reader.getNullable(JsonReader::getInt);
                } else if ("onlyLongestMatch".equals(fieldName)) {
                    onlyLongestMatched = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }
            if (nameFound && wordListFound) {
                DictionaryDecompounderTokenFilter deserializedDictionaryDecompounderTokenFilter
                    = new DictionaryDecompounderTokenFilter(name, wordList);
                deserializedDictionaryDecompounderTokenFilter.odataType = odataType;
                deserializedDictionaryDecompounderTokenFilter.minWordSize = minWordSize;
                deserializedDictionaryDecompounderTokenFilter.minSubwordSize = minSubwordSize;
                deserializedDictionaryDecompounderTokenFilter.maxSubwordSize = maxSubwordSize;
                deserializedDictionaryDecompounderTokenFilter.onlyLongestMatched = onlyLongestMatched;

                return deserializedDictionaryDecompounderTokenFilter;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!wordListFound) {
                missingProperties.add("wordList");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
