// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * A skill that extracts content and layout information, via Azure AI Services, from files within the enrichment
 * pipeline.
 */
@Fluent
public final class DocumentIntelligenceLayoutSkill extends SearchIndexerSkill {
    /*
     * A URI fragment specifying the type of skill.
     */
    @Generated
    private String odataType = "#Microsoft.Skills.Util.DocumentIntelligenceLayoutSkill";

    /*
     * Controls the cardinality of the output format. Default is 'markdown'.
     */
    @Generated
    private DocumentIntelligenceLayoutSkillOutputFormat outputFormat;

    /*
     * Controls the cardinality of the output produced by the skill. Default is 'oneToMany'.
     */
    @Generated
    private DocumentIntelligenceLayoutSkillOutputMode outputMode;

    /*
     * The depth of headers in the markdown output. Default is h6.
     */
    @Generated
    private DocumentIntelligenceLayoutSkillMarkdownHeaderDepth markdownHeaderDepth;

    /*
     * Controls the cardinality of the content extracted from the document by the skill
     */
    @Generated
    private List<DocumentIntelligenceLayoutSkillExtractionOptions> extractionOptions;

    /*
     * Controls the cardinality for chunking the content.
     */
    @Generated
    private DocumentIntelligenceLayoutSkillChunkingProperties chunkingProperties;

    /**
     * Creates an instance of DocumentIntelligenceLayoutSkill class.
     * 
     * @param inputs the inputs value to set.
     * @param outputs the outputs value to set.
     */
    @Generated
    public DocumentIntelligenceLayoutSkill(List<InputFieldMappingEntry> inputs, List<OutputFieldMappingEntry> outputs) {
        super(inputs, outputs);
    }

    /**
     * Get the odataType property: A URI fragment specifying the type of skill.
     * 
     * @return the odataType value.
     */
    @Generated
    @Override
    public String getOdataType() {
        return this.odataType;
    }

    /**
     * Get the outputFormat property: Controls the cardinality of the output format. Default is 'markdown'.
     * 
     * @return the outputFormat value.
     */
    @Generated
    public DocumentIntelligenceLayoutSkillOutputFormat getOutputFormat() {
        return this.outputFormat;
    }

    /**
     * Set the outputFormat property: Controls the cardinality of the output format. Default is 'markdown'.
     * 
     * @param outputFormat the outputFormat value to set.
     * @return the DocumentIntelligenceLayoutSkill object itself.
     */
    @Generated
    public DocumentIntelligenceLayoutSkill setOutputFormat(DocumentIntelligenceLayoutSkillOutputFormat outputFormat) {
        this.outputFormat = outputFormat;
        return this;
    }

    /**
     * Get the outputMode property: Controls the cardinality of the output produced by the skill. Default is
     * 'oneToMany'.
     * 
     * @return the outputMode value.
     */
    @Generated
    public DocumentIntelligenceLayoutSkillOutputMode getOutputMode() {
        return this.outputMode;
    }

    /**
     * Set the outputMode property: Controls the cardinality of the output produced by the skill. Default is
     * 'oneToMany'.
     * 
     * @param outputMode the outputMode value to set.
     * @return the DocumentIntelligenceLayoutSkill object itself.
     */
    @Generated
    public DocumentIntelligenceLayoutSkill setOutputMode(DocumentIntelligenceLayoutSkillOutputMode outputMode) {
        this.outputMode = outputMode;
        return this;
    }

    /**
     * Get the markdownHeaderDepth property: The depth of headers in the markdown output. Default is h6.
     * 
     * @return the markdownHeaderDepth value.
     */
    @Generated
    public DocumentIntelligenceLayoutSkillMarkdownHeaderDepth getMarkdownHeaderDepth() {
        return this.markdownHeaderDepth;
    }

    /**
     * Set the markdownHeaderDepth property: The depth of headers in the markdown output. Default is h6.
     * 
     * @param markdownHeaderDepth the markdownHeaderDepth value to set.
     * @return the DocumentIntelligenceLayoutSkill object itself.
     */
    @Generated
    public DocumentIntelligenceLayoutSkill
        setMarkdownHeaderDepth(DocumentIntelligenceLayoutSkillMarkdownHeaderDepth markdownHeaderDepth) {
        this.markdownHeaderDepth = markdownHeaderDepth;
        return this;
    }

    /**
     * Get the extractionOptions property: Controls the cardinality of the content extracted from the document by the
     * skill.
     * 
     * @return the extractionOptions value.
     */
    @Generated
    public List<DocumentIntelligenceLayoutSkillExtractionOptions> getExtractionOptions() {
        return this.extractionOptions;
    }

    /**
     * Set the extractionOptions property: Controls the cardinality of the content extracted from the document by the
     * skill.
     * 
     * @param extractionOptions the extractionOptions value to set.
     * @return the DocumentIntelligenceLayoutSkill object itself.
     */
    @Generated
    public DocumentIntelligenceLayoutSkill
        setExtractionOptions(List<DocumentIntelligenceLayoutSkillExtractionOptions> extractionOptions) {
        this.extractionOptions = extractionOptions;
        return this;
    }

    /**
     * Get the chunkingProperties property: Controls the cardinality for chunking the content.
     * 
     * @return the chunkingProperties value.
     */
    @Generated
    public DocumentIntelligenceLayoutSkillChunkingProperties getChunkingProperties() {
        return this.chunkingProperties;
    }

    /**
     * Set the chunkingProperties property: Controls the cardinality for chunking the content.
     * 
     * @param chunkingProperties the chunkingProperties value to set.
     * @return the DocumentIntelligenceLayoutSkill object itself.
     */
    @Generated
    public DocumentIntelligenceLayoutSkill
        setChunkingProperties(DocumentIntelligenceLayoutSkillChunkingProperties chunkingProperties) {
        this.chunkingProperties = chunkingProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public DocumentIntelligenceLayoutSkill setName(String name) {
        super.setName(name);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public DocumentIntelligenceLayoutSkill setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public DocumentIntelligenceLayoutSkill setContext(String context) {
        super.setContext(context);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("inputs", getInputs(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("outputs", getOutputs(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("name", getName());
        jsonWriter.writeStringField("description", getDescription());
        jsonWriter.writeStringField("context", getContext());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeStringField("outputFormat", this.outputFormat == null ? null : this.outputFormat.toString());
        jsonWriter.writeStringField("outputMode", this.outputMode == null ? null : this.outputMode.toString());
        jsonWriter.writeStringField("markdownHeaderDepth",
            this.markdownHeaderDepth == null ? null : this.markdownHeaderDepth.toString());
        jsonWriter.writeArrayField("extractionOptions", this.extractionOptions,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeJsonField("chunkingProperties", this.chunkingProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DocumentIntelligenceLayoutSkill from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DocumentIntelligenceLayoutSkill if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DocumentIntelligenceLayoutSkill.
     */
    @Generated
    public static DocumentIntelligenceLayoutSkill fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean inputsFound = false;
            List<InputFieldMappingEntry> inputs = null;
            boolean outputsFound = false;
            List<OutputFieldMappingEntry> outputs = null;
            String name = null;
            String description = null;
            String context = null;
            String odataType = "#Microsoft.Skills.Util.DocumentIntelligenceLayoutSkill";
            DocumentIntelligenceLayoutSkillOutputFormat outputFormat = null;
            DocumentIntelligenceLayoutSkillOutputMode outputMode = null;
            DocumentIntelligenceLayoutSkillMarkdownHeaderDepth markdownHeaderDepth = null;
            List<DocumentIntelligenceLayoutSkillExtractionOptions> extractionOptions = null;
            DocumentIntelligenceLayoutSkillChunkingProperties chunkingProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("inputs".equals(fieldName)) {
                    inputs = reader.readArray(reader1 -> InputFieldMappingEntry.fromJson(reader1));
                    inputsFound = true;
                } else if ("outputs".equals(fieldName)) {
                    outputs = reader.readArray(reader1 -> OutputFieldMappingEntry.fromJson(reader1));
                    outputsFound = true;
                } else if ("name".equals(fieldName)) {
                    name = reader.getString();
                } else if ("description".equals(fieldName)) {
                    description = reader.getString();
                } else if ("context".equals(fieldName)) {
                    context = reader.getString();
                } else if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                } else if ("outputFormat".equals(fieldName)) {
                    outputFormat = DocumentIntelligenceLayoutSkillOutputFormat.fromString(reader.getString());
                } else if ("outputMode".equals(fieldName)) {
                    outputMode = DocumentIntelligenceLayoutSkillOutputMode.fromString(reader.getString());
                } else if ("markdownHeaderDepth".equals(fieldName)) {
                    markdownHeaderDepth
                        = DocumentIntelligenceLayoutSkillMarkdownHeaderDepth.fromString(reader.getString());
                } else if ("extractionOptions".equals(fieldName)) {
                    extractionOptions = reader.readArray(
                        reader1 -> DocumentIntelligenceLayoutSkillExtractionOptions.fromString(reader1.getString()));
                } else if ("chunkingProperties".equals(fieldName)) {
                    chunkingProperties = DocumentIntelligenceLayoutSkillChunkingProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            if (inputsFound && outputsFound) {
                DocumentIntelligenceLayoutSkill deserializedDocumentIntelligenceLayoutSkill
                    = new DocumentIntelligenceLayoutSkill(inputs, outputs);
                deserializedDocumentIntelligenceLayoutSkill.setName(name);
                deserializedDocumentIntelligenceLayoutSkill.setDescription(description);
                deserializedDocumentIntelligenceLayoutSkill.setContext(context);
                deserializedDocumentIntelligenceLayoutSkill.odataType = odataType;
                deserializedDocumentIntelligenceLayoutSkill.outputFormat = outputFormat;
                deserializedDocumentIntelligenceLayoutSkill.outputMode = outputMode;
                deserializedDocumentIntelligenceLayoutSkill.markdownHeaderDepth = markdownHeaderDepth;
                deserializedDocumentIntelligenceLayoutSkill.extractionOptions = extractionOptions;
                deserializedDocumentIntelligenceLayoutSkill.chunkingProperties = chunkingProperties;

                return deserializedDocumentIntelligenceLayoutSkill;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!inputsFound) {
                missingProperties.add("inputs");
            }
            if (!outputsFound) {
                missingProperties.add("outputs");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
