// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Controls the cardinality for chunking the content.
 */
@Fluent
public final class DocumentIntelligenceLayoutSkillChunkingProperties
    implements JsonSerializable<DocumentIntelligenceLayoutSkillChunkingProperties> {
    /*
     * The unit of the chunk.
     */
    @Generated
    private DocumentIntelligenceLayoutSkillChunkingUnit unit;

    /*
     * The maximum chunk length in characters. Default is 500.
     */
    @Generated
    private Integer maximumLength;

    /*
     * The length of overlap provided between two text chunks. Default is 0.
     */
    @Generated
    private Integer overlapLength;

    /**
     * Creates an instance of DocumentIntelligenceLayoutSkillChunkingProperties class.
     */
    @Generated
    public DocumentIntelligenceLayoutSkillChunkingProperties() {
    }

    /**
     * Get the unit property: The unit of the chunk.
     * 
     * @return the unit value.
     */
    @Generated
    public DocumentIntelligenceLayoutSkillChunkingUnit getUnit() {
        return this.unit;
    }

    /**
     * Set the unit property: The unit of the chunk.
     * 
     * @param unit the unit value to set.
     * @return the DocumentIntelligenceLayoutSkillChunkingProperties object itself.
     */
    @Generated
    public DocumentIntelligenceLayoutSkillChunkingProperties setUnit(DocumentIntelligenceLayoutSkillChunkingUnit unit) {
        this.unit = unit;
        return this;
    }

    /**
     * Get the maximumLength property: The maximum chunk length in characters. Default is 500.
     * 
     * @return the maximumLength value.
     */
    @Generated
    public Integer getMaximumLength() {
        return this.maximumLength;
    }

    /**
     * Set the maximumLength property: The maximum chunk length in characters. Default is 500.
     * 
     * @param maximumLength the maximumLength value to set.
     * @return the DocumentIntelligenceLayoutSkillChunkingProperties object itself.
     */
    @Generated
    public DocumentIntelligenceLayoutSkillChunkingProperties setMaximumLength(Integer maximumLength) {
        this.maximumLength = maximumLength;
        return this;
    }

    /**
     * Get the overlapLength property: The length of overlap provided between two text chunks. Default is 0.
     * 
     * @return the overlapLength value.
     */
    @Generated
    public Integer getOverlapLength() {
        return this.overlapLength;
    }

    /**
     * Set the overlapLength property: The length of overlap provided between two text chunks. Default is 0.
     * 
     * @param overlapLength the overlapLength value to set.
     * @return the DocumentIntelligenceLayoutSkillChunkingProperties object itself.
     */
    @Generated
    public DocumentIntelligenceLayoutSkillChunkingProperties setOverlapLength(Integer overlapLength) {
        this.overlapLength = overlapLength;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("unit", this.unit == null ? null : this.unit.toString());
        jsonWriter.writeNumberField("maximumLength", this.maximumLength);
        jsonWriter.writeNumberField("overlapLength", this.overlapLength);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DocumentIntelligenceLayoutSkillChunkingProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DocumentIntelligenceLayoutSkillChunkingProperties if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DocumentIntelligenceLayoutSkillChunkingProperties.
     */
    @Generated
    public static DocumentIntelligenceLayoutSkillChunkingProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DocumentIntelligenceLayoutSkillChunkingProperties deserializedDocumentIntelligenceLayoutSkillChunkingProperties
                = new DocumentIntelligenceLayoutSkillChunkingProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("unit".equals(fieldName)) {
                    deserializedDocumentIntelligenceLayoutSkillChunkingProperties.unit
                        = DocumentIntelligenceLayoutSkillChunkingUnit.fromString(reader.getString());
                } else if ("maximumLength".equals(fieldName)) {
                    deserializedDocumentIntelligenceLayoutSkillChunkingProperties.maximumLength
                        = reader.getNullable(JsonReader::getInt);
                } else if ("overlapLength".equals(fieldName)) {
                    deserializedDocumentIntelligenceLayoutSkillChunkingProperties.overlapLength
                        = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDocumentIntelligenceLayoutSkillChunkingProperties;
        });
    }
}
