// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Contains configuration options specific to the exhaustive KNN algorithm used during querying, which will perform
 * brute-force search across the entire vector index.
 */
@Fluent
public final class ExhaustiveKnnAlgorithmConfiguration extends VectorSearchAlgorithmConfiguration {
    /*
     * The name of the kind of algorithm being configured for use with vector search.
     */
    @Generated
    private VectorSearchAlgorithmKind kind = VectorSearchAlgorithmKind.EXHAUSTIVE_KNN;

    /*
     * Contains the parameters specific to exhaustive KNN algorithm.
     */
    @Generated
    private ExhaustiveKnnParameters parameters;

    /**
     * Creates an instance of ExhaustiveKnnAlgorithmConfiguration class.
     * 
     * @param name the name value to set.
     */
    @Generated
    public ExhaustiveKnnAlgorithmConfiguration(String name) {
        super(name);
    }

    /**
     * Get the kind property: The name of the kind of algorithm being configured for use with vector search.
     * 
     * @return the kind value.
     */
    @Generated
    @Override
    public VectorSearchAlgorithmKind getKind() {
        return this.kind;
    }

    /**
     * Get the parameters property: Contains the parameters specific to exhaustive KNN algorithm.
     * 
     * @return the parameters value.
     */
    @Generated
    public ExhaustiveKnnParameters getParameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: Contains the parameters specific to exhaustive KNN algorithm.
     * 
     * @param parameters the parameters value to set.
     * @return the ExhaustiveKnnAlgorithmConfiguration object itself.
     */
    @Generated
    public ExhaustiveKnnAlgorithmConfiguration setParameters(ExhaustiveKnnParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", getName());
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeJsonField("exhaustiveKnnParameters", this.parameters);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExhaustiveKnnAlgorithmConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExhaustiveKnnAlgorithmConfiguration if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ExhaustiveKnnAlgorithmConfiguration.
     */
    @Generated
    public static ExhaustiveKnnAlgorithmConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            VectorSearchAlgorithmKind kind = VectorSearchAlgorithmKind.EXHAUSTIVE_KNN;
            ExhaustiveKnnParameters parameters = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                } else if ("kind".equals(fieldName)) {
                    kind = VectorSearchAlgorithmKind.fromString(reader.getString());
                } else if ("exhaustiveKnnParameters".equals(fieldName)) {
                    parameters = ExhaustiveKnnParameters.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            if (nameFound) {
                ExhaustiveKnnAlgorithmConfiguration deserializedExhaustiveKnnAlgorithmConfiguration
                    = new ExhaustiveKnnAlgorithmConfiguration(name);
                deserializedExhaustiveKnnAlgorithmConfiguration.kind = kind;
                deserializedExhaustiveKnnAlgorithmConfiguration.parameters = parameters;

                return deserializedExhaustiveKnnAlgorithmConfiguration;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}
