// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Represents a schedule for indexer execution.
 */
@Fluent
public final class IndexingSchedule implements JsonSerializable<IndexingSchedule> {
    /*
     * The interval of time between indexer executions.
     */
    @Generated
    private final Duration interval;

    /*
     * The time when an indexer should start running.
     */
    @Generated
    private OffsetDateTime startTime;

    /**
     * Creates an instance of IndexingSchedule class.
     * 
     * @param interval the interval value to set.
     */
    @Generated
    public IndexingSchedule(Duration interval) {
        this.interval = interval;
    }

    /**
     * Get the interval property: The interval of time between indexer executions.
     * 
     * @return the interval value.
     */
    @Generated
    public Duration getInterval() {
        return this.interval;
    }

    /**
     * Get the startTime property: The time when an indexer should start running.
     * 
     * @return the startTime value.
     */
    @Generated
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    /**
     * Set the startTime property: The time when an indexer should start running.
     * 
     * @param startTime the startTime value to set.
     * @return the IndexingSchedule object itself.
     */
    @Generated
    public IndexingSchedule setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("interval", CoreUtils.durationToStringWithDays(this.interval));
        jsonWriter.writeStringField("startTime",
            this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IndexingSchedule from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IndexingSchedule if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the IndexingSchedule.
     */
    @Generated
    public static IndexingSchedule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean intervalFound = false;
            Duration interval = null;
            OffsetDateTime startTime = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("interval".equals(fieldName)) {
                    interval = reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    intervalFound = true;
                } else if ("startTime".equals(fieldName)) {
                    startTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }
            if (intervalFound) {
                IndexingSchedule deserializedIndexingSchedule = new IndexingSchedule(interval);
                deserializedIndexingSchedule.startTime = startTime;

                return deserializedIndexingSchedule;
            }
            throw new IllegalStateException("Missing required property: interval");
        });
    }
}
