// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * The KnowledgeAgent model.
 */
@Fluent
public final class KnowledgeAgent implements JsonSerializable<KnowledgeAgent> {
    /*
     * The name of the knowledge agent.
     */
    @Generated
    private final String name;

    /*
     * Contains configuration options on how to connect to AI models.
     */
    @Generated
    private final List<KnowledgeAgentModel> models;

    /*
     * The knowledgeSources property.
     */
    @Generated
    private final List<KnowledgeSourceReference> knowledgeSources;

    /*
     * The outputConfiguration property.
     */
    @Generated
    private KnowledgeAgentOutputConfiguration outputConfiguration;

    /*
     * Guardrails to limit how much resources are utilized for a single agent retrieval request.
     */
    @Generated
    private KnowledgeAgentRequestLimits requestLimits;

    /*
     * Instructions considered by the knowledge agent when developing query plan.
     */
    @Generated
    private String retrievalInstructions;

    /*
     * The ETag of the agent.
     */
    @Generated
    private String eTag;

    /*
     * A description of an encryption key that you create in Azure Key Vault. This key is used to provide an additional
     * level of encryption-at-rest for your agent definition when you want full assurance that no one, not even
     * Microsoft, can decrypt them. Once you have encrypted your agent definition, it will always remain encrypted. The
     * search service will ignore attempts to set this property to null. You can change this property as needed if you
     * want to rotate your encryption key; Your agent definition will be unaffected. Encryption with customer-managed
     * keys is not available for free search services, and is only available for paid services created on or after
     * January 1, 2019.
     */
    @Generated
    private SearchResourceEncryptionKey encryptionKey;

    /*
     * The description of the agent.
     */
    @Generated
    private String description;

    /**
     * Creates an instance of KnowledgeAgent class.
     * 
     * @param name the name value to set.
     * @param models the models value to set.
     * @param knowledgeSources the knowledgeSources value to set.
     */
    @Generated
    public KnowledgeAgent(String name, List<KnowledgeAgentModel> models,
        List<KnowledgeSourceReference> knowledgeSources) {
        this.name = name;
        this.models = models;
        this.knowledgeSources = knowledgeSources;
    }

    /**
     * Get the name property: The name of the knowledge agent.
     * 
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * Get the models property: Contains configuration options on how to connect to AI models.
     * 
     * @return the models value.
     */
    @Generated
    public List<KnowledgeAgentModel> getModels() {
        return this.models;
    }

    /**
     * Get the knowledgeSources property: The knowledgeSources property.
     * 
     * @return the knowledgeSources value.
     */
    @Generated
    public List<KnowledgeSourceReference> getKnowledgeSources() {
        return this.knowledgeSources;
    }

    /**
     * Get the outputConfiguration property: The outputConfiguration property.
     * 
     * @return the outputConfiguration value.
     */
    @Generated
    public KnowledgeAgentOutputConfiguration getOutputConfiguration() {
        return this.outputConfiguration;
    }

    /**
     * Set the outputConfiguration property: The outputConfiguration property.
     * 
     * @param outputConfiguration the outputConfiguration value to set.
     * @return the KnowledgeAgent object itself.
     */
    @Generated
    public KnowledgeAgent setOutputConfiguration(KnowledgeAgentOutputConfiguration outputConfiguration) {
        this.outputConfiguration = outputConfiguration;
        return this;
    }

    /**
     * Get the requestLimits property: Guardrails to limit how much resources are utilized for a single agent retrieval
     * request.
     * 
     * @return the requestLimits value.
     */
    @Generated
    public KnowledgeAgentRequestLimits getRequestLimits() {
        return this.requestLimits;
    }

    /**
     * Set the requestLimits property: Guardrails to limit how much resources are utilized for a single agent retrieval
     * request.
     * 
     * @param requestLimits the requestLimits value to set.
     * @return the KnowledgeAgent object itself.
     */
    @Generated
    public KnowledgeAgent setRequestLimits(KnowledgeAgentRequestLimits requestLimits) {
        this.requestLimits = requestLimits;
        return this;
    }

    /**
     * Get the retrievalInstructions property: Instructions considered by the knowledge agent when developing query
     * plan.
     * 
     * @return the retrievalInstructions value.
     */
    @Generated
    public String getRetrievalInstructions() {
        return this.retrievalInstructions;
    }

    /**
     * Set the retrievalInstructions property: Instructions considered by the knowledge agent when developing query
     * plan.
     * 
     * @param retrievalInstructions the retrievalInstructions value to set.
     * @return the KnowledgeAgent object itself.
     */
    @Generated
    public KnowledgeAgent setRetrievalInstructions(String retrievalInstructions) {
        this.retrievalInstructions = retrievalInstructions;
        return this;
    }

    /**
     * Get the eTag property: The ETag of the agent.
     * 
     * @return the eTag value.
     */
    @Generated
    public String getETag() {
        return this.eTag;
    }

    /**
     * Set the eTag property: The ETag of the agent.
     * 
     * @param eTag the eTag value to set.
     * @return the KnowledgeAgent object itself.
     */
    @Generated
    public KnowledgeAgent setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    /**
     * Get the encryptionKey property: A description of an encryption key that you create in Azure Key Vault. This key
     * is used to provide an additional level of encryption-at-rest for your agent definition when you want full
     * assurance that no one, not even Microsoft, can decrypt them. Once you have encrypted your agent definition, it
     * will always remain encrypted. The search service will ignore attempts to set this property to null. You can
     * change this property as needed if you want to rotate your encryption key; Your agent definition will be
     * unaffected. Encryption with customer-managed keys is not available for free search services, and is only
     * available for paid services created on or after January 1, 2019.
     * 
     * @return the encryptionKey value.
     */
    @Generated
    public SearchResourceEncryptionKey getEncryptionKey() {
        return this.encryptionKey;
    }

    /**
     * Set the encryptionKey property: A description of an encryption key that you create in Azure Key Vault. This key
     * is used to provide an additional level of encryption-at-rest for your agent definition when you want full
     * assurance that no one, not even Microsoft, can decrypt them. Once you have encrypted your agent definition, it
     * will always remain encrypted. The search service will ignore attempts to set this property to null. You can
     * change this property as needed if you want to rotate your encryption key; Your agent definition will be
     * unaffected. Encryption with customer-managed keys is not available for free search services, and is only
     * available for paid services created on or after January 1, 2019.
     * 
     * @param encryptionKey the encryptionKey value to set.
     * @return the KnowledgeAgent object itself.
     */
    @Generated
    public KnowledgeAgent setEncryptionKey(SearchResourceEncryptionKey encryptionKey) {
        this.encryptionKey = encryptionKey;
        return this;
    }

    /**
     * Get the description property: The description of the agent.
     * 
     * @return the description value.
     */
    @Generated
    public String getDescription() {
        return this.description;
    }

    /**
     * Set the description property: The description of the agent.
     * 
     * @param description the description value to set.
     * @return the KnowledgeAgent object itself.
     */
    @Generated
    public KnowledgeAgent setDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("models", this.models, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("knowledgeSources", this.knowledgeSources,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("outputConfiguration", this.outputConfiguration);
        jsonWriter.writeJsonField("requestLimits", this.requestLimits);
        jsonWriter.writeStringField("retrievalInstructions", this.retrievalInstructions);
        jsonWriter.writeStringField("@odata.etag", this.eTag);
        jsonWriter.writeJsonField("encryptionKey", this.encryptionKey);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeAgent from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeAgent if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KnowledgeAgent.
     */
    @Generated
    public static KnowledgeAgent fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            boolean modelsFound = false;
            List<KnowledgeAgentModel> models = null;
            boolean knowledgeSourcesFound = false;
            List<KnowledgeSourceReference> knowledgeSources = null;
            KnowledgeAgentOutputConfiguration outputConfiguration = null;
            KnowledgeAgentRequestLimits requestLimits = null;
            String retrievalInstructions = null;
            String eTag = null;
            SearchResourceEncryptionKey encryptionKey = null;
            String description = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                } else if ("models".equals(fieldName)) {
                    models = reader.readArray(reader1 -> KnowledgeAgentModel.fromJson(reader1));
                    modelsFound = true;
                } else if ("knowledgeSources".equals(fieldName)) {
                    knowledgeSources = reader.readArray(reader1 -> KnowledgeSourceReference.fromJson(reader1));
                    knowledgeSourcesFound = true;
                } else if ("outputConfiguration".equals(fieldName)) {
                    outputConfiguration = KnowledgeAgentOutputConfiguration.fromJson(reader);
                } else if ("requestLimits".equals(fieldName)) {
                    requestLimits = KnowledgeAgentRequestLimits.fromJson(reader);
                } else if ("retrievalInstructions".equals(fieldName)) {
                    retrievalInstructions = reader.getString();
                } else if ("@odata.etag".equals(fieldName)) {
                    eTag = reader.getString();
                } else if ("encryptionKey".equals(fieldName)) {
                    encryptionKey = SearchResourceEncryptionKey.fromJson(reader);
                } else if ("description".equals(fieldName)) {
                    description = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            if (nameFound && modelsFound && knowledgeSourcesFound) {
                KnowledgeAgent deserializedKnowledgeAgent = new KnowledgeAgent(name, models, knowledgeSources);
                deserializedKnowledgeAgent.outputConfiguration = outputConfiguration;
                deserializedKnowledgeAgent.requestLimits = requestLimits;
                deserializedKnowledgeAgent.retrievalInstructions = retrievalInstructions;
                deserializedKnowledgeAgent.eTag = eTag;
                deserializedKnowledgeAgent.encryptionKey = encryptionKey;
                deserializedKnowledgeAgent.description = description;

                return deserializedKnowledgeAgent;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!modelsFound) {
                missingProperties.add("models");
            }
            if (!knowledgeSourcesFound) {
                missingProperties.add("knowledgeSources");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
