// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The KnowledgeAgentOutputConfiguration model.
 */
@Fluent
public final class KnowledgeAgentOutputConfiguration implements JsonSerializable<KnowledgeAgentOutputConfiguration> {
    /*
     * The output configuration for the agent
     */
    @Generated
    private KnowledgeAgentOutputConfigurationModality modality;

    /*
     * Instructions considered by the knowledge agent when generating answers
     */
    @Generated
    private String answerInstructions;

    /*
     * Indicates whether the agent should attempt to issue the most recent chat message as a direct query to the
     * knowledge sources, bypassing the model calls.
     */
    @Generated
    private Boolean attemptFastPath;

    /*
     * Indicates retrieval results should include activity information.
     */
    @Generated
    private Boolean includeActivity;

    /**
     * Creates an instance of KnowledgeAgentOutputConfiguration class.
     */
    @Generated
    public KnowledgeAgentOutputConfiguration() {
    }

    /**
     * Get the modality property: The output configuration for the agent.
     * 
     * @return the modality value.
     */
    @Generated
    public KnowledgeAgentOutputConfigurationModality getModality() {
        return this.modality;
    }

    /**
     * Set the modality property: The output configuration for the agent.
     * 
     * @param modality the modality value to set.
     * @return the KnowledgeAgentOutputConfiguration object itself.
     */
    @Generated
    public KnowledgeAgentOutputConfiguration setModality(KnowledgeAgentOutputConfigurationModality modality) {
        this.modality = modality;
        return this;
    }

    /**
     * Get the answerInstructions property: Instructions considered by the knowledge agent when generating answers.
     * 
     * @return the answerInstructions value.
     */
    @Generated
    public String getAnswerInstructions() {
        return this.answerInstructions;
    }

    /**
     * Set the answerInstructions property: Instructions considered by the knowledge agent when generating answers.
     * 
     * @param answerInstructions the answerInstructions value to set.
     * @return the KnowledgeAgentOutputConfiguration object itself.
     */
    @Generated
    public KnowledgeAgentOutputConfiguration setAnswerInstructions(String answerInstructions) {
        this.answerInstructions = answerInstructions;
        return this;
    }

    /**
     * Get the attemptFastPath property: Indicates whether the agent should attempt to issue the most recent chat
     * message as a direct query to the knowledge sources, bypassing the model calls.
     * 
     * @return the attemptFastPath value.
     */
    @Generated
    public Boolean isAttemptFastPath() {
        return this.attemptFastPath;
    }

    /**
     * Set the attemptFastPath property: Indicates whether the agent should attempt to issue the most recent chat
     * message as a direct query to the knowledge sources, bypassing the model calls.
     * 
     * @param attemptFastPath the attemptFastPath value to set.
     * @return the KnowledgeAgentOutputConfiguration object itself.
     */
    @Generated
    public KnowledgeAgentOutputConfiguration setAttemptFastPath(Boolean attemptFastPath) {
        this.attemptFastPath = attemptFastPath;
        return this;
    }

    /**
     * Get the includeActivity property: Indicates retrieval results should include activity information.
     * 
     * @return the includeActivity value.
     */
    @Generated
    public Boolean isIncludeActivity() {
        return this.includeActivity;
    }

    /**
     * Set the includeActivity property: Indicates retrieval results should include activity information.
     * 
     * @param includeActivity the includeActivity value to set.
     * @return the KnowledgeAgentOutputConfiguration object itself.
     */
    @Generated
    public KnowledgeAgentOutputConfiguration setIncludeActivity(Boolean includeActivity) {
        this.includeActivity = includeActivity;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("modality", this.modality == null ? null : this.modality.toString());
        jsonWriter.writeStringField("answerInstructions", this.answerInstructions);
        jsonWriter.writeBooleanField("attemptFastPath", this.attemptFastPath);
        jsonWriter.writeBooleanField("includeActivity", this.includeActivity);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeAgentOutputConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeAgentOutputConfiguration if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the KnowledgeAgentOutputConfiguration.
     */
    @Generated
    public static KnowledgeAgentOutputConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KnowledgeAgentOutputConfiguration deserializedKnowledgeAgentOutputConfiguration
                = new KnowledgeAgentOutputConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("modality".equals(fieldName)) {
                    deserializedKnowledgeAgentOutputConfiguration.modality
                        = KnowledgeAgentOutputConfigurationModality.fromString(reader.getString());
                } else if ("answerInstructions".equals(fieldName)) {
                    deserializedKnowledgeAgentOutputConfiguration.answerInstructions = reader.getString();
                } else if ("attemptFastPath".equals(fieldName)) {
                    deserializedKnowledgeAgentOutputConfiguration.attemptFastPath
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("includeActivity".equals(fieldName)) {
                    deserializedKnowledgeAgentOutputConfiguration.includeActivity
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKnowledgeAgentOutputConfiguration;
        });
    }
}
