// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Guardrails to limit how much resources are utilized for a single agent retrieval request.
 */
@Fluent
public final class KnowledgeAgentRequestLimits implements JsonSerializable<KnowledgeAgentRequestLimits> {
    /*
     * The maximum runtime in seconds.
     */
    @Generated
    private Integer maxRuntimeInSeconds;

    /*
     * Limits the maximum size of the content in the output.
     */
    @Generated
    private Integer maxOutputSize;

    /**
     * Creates an instance of KnowledgeAgentRequestLimits class.
     */
    @Generated
    public KnowledgeAgentRequestLimits() {
    }

    /**
     * Get the maxRuntimeInSeconds property: The maximum runtime in seconds.
     * 
     * @return the maxRuntimeInSeconds value.
     */
    @Generated
    public Integer getMaxRuntimeInSeconds() {
        return this.maxRuntimeInSeconds;
    }

    /**
     * Set the maxRuntimeInSeconds property: The maximum runtime in seconds.
     * 
     * @param maxRuntimeInSeconds the maxRuntimeInSeconds value to set.
     * @return the KnowledgeAgentRequestLimits object itself.
     */
    @Generated
    public KnowledgeAgentRequestLimits setMaxRuntimeInSeconds(Integer maxRuntimeInSeconds) {
        this.maxRuntimeInSeconds = maxRuntimeInSeconds;
        return this;
    }

    /**
     * Get the maxOutputSize property: Limits the maximum size of the content in the output.
     * 
     * @return the maxOutputSize value.
     */
    @Generated
    public Integer getMaxOutputSize() {
        return this.maxOutputSize;
    }

    /**
     * Set the maxOutputSize property: Limits the maximum size of the content in the output.
     * 
     * @param maxOutputSize the maxOutputSize value to set.
     * @return the KnowledgeAgentRequestLimits object itself.
     */
    @Generated
    public KnowledgeAgentRequestLimits setMaxOutputSize(Integer maxOutputSize) {
        this.maxOutputSize = maxOutputSize;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("maxRuntimeInSeconds", this.maxRuntimeInSeconds);
        jsonWriter.writeNumberField("maxOutputSize", this.maxOutputSize);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeAgentRequestLimits from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeAgentRequestLimits if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the KnowledgeAgentRequestLimits.
     */
    @Generated
    public static KnowledgeAgentRequestLimits fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KnowledgeAgentRequestLimits deserializedKnowledgeAgentRequestLimits = new KnowledgeAgentRequestLimits();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("maxRuntimeInSeconds".equals(fieldName)) {
                    deserializedKnowledgeAgentRequestLimits.maxRuntimeInSeconds
                        = reader.getNullable(JsonReader::getInt);
                } else if ("maxOutputSize".equals(fieldName)) {
                    deserializedKnowledgeAgentRequestLimits.maxOutputSize = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKnowledgeAgentRequestLimits;
        });
    }
}
