// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents a knowledge source definition.
 */
@Fluent
public class KnowledgeSource implements JsonSerializable<KnowledgeSource> {
    /*
     * The type of the knowledge source.
     */
    @Generated
    private KnowledgeSourceKind kind = KnowledgeSourceKind.fromString("KnowledgeSource");

    /*
     * The name of the knowledge source.
     */
    @Generated
    private final String name;

    /*
     * Optional user-defined description.
     */
    @Generated
    private String description;

    /*
     * The ETag of the agent.
     */
    @Generated
    private String eTag;

    /*
     * A description of an encryption key that you create in Azure Key Vault. This key is used to provide an additional
     * level of encryption-at-rest for your agent definition when you want full assurance that no one, not even
     * Microsoft, can decrypt them. Once you have encrypted your agent definition, it will always remain encrypted. The
     * search service will ignore attempts to set this property to null. You can change this property as needed if you
     * want to rotate your encryption key; Your agent definition will be unaffected. Encryption with customer-managed
     * keys is not available for free search services, and is only available for paid services created on or after
     * January 1, 2019.
     */
    @Generated
    private SearchResourceEncryptionKey encryptionKey;

    /**
     * Creates an instance of KnowledgeSource class.
     * 
     * @param name the name value to set.
     */
    @Generated
    public KnowledgeSource(String name) {
        this.name = name;
    }

    /**
     * Get the kind property: The type of the knowledge source.
     * 
     * @return the kind value.
     */
    @Generated
    public KnowledgeSourceKind getKind() {
        return this.kind;
    }

    /**
     * Get the name property: The name of the knowledge source.
     * 
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * Get the description property: Optional user-defined description.
     * 
     * @return the description value.
     */
    @Generated
    public String getDescription() {
        return this.description;
    }

    /**
     * Set the description property: Optional user-defined description.
     * 
     * @param description the description value to set.
     * @return the KnowledgeSource object itself.
     */
    @Generated
    public KnowledgeSource setDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the eTag property: The ETag of the agent.
     * 
     * @return the eTag value.
     */
    @Generated
    public String getETag() {
        return this.eTag;
    }

    /**
     * Set the eTag property: The ETag of the agent.
     * 
     * @param eTag the eTag value to set.
     * @return the KnowledgeSource object itself.
     */
    @Generated
    public KnowledgeSource setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    /**
     * Get the encryptionKey property: A description of an encryption key that you create in Azure Key Vault. This key
     * is used to provide an additional level of encryption-at-rest for your agent definition when you want full
     * assurance that no one, not even Microsoft, can decrypt them. Once you have encrypted your agent definition, it
     * will always remain encrypted. The search service will ignore attempts to set this property to null. You can
     * change this property as needed if you want to rotate your encryption key; Your agent definition will be
     * unaffected. Encryption with customer-managed keys is not available for free search services, and is only
     * available for paid services created on or after January 1, 2019.
     * 
     * @return the encryptionKey value.
     */
    @Generated
    public SearchResourceEncryptionKey getEncryptionKey() {
        return this.encryptionKey;
    }

    /**
     * Set the encryptionKey property: A description of an encryption key that you create in Azure Key Vault. This key
     * is used to provide an additional level of encryption-at-rest for your agent definition when you want full
     * assurance that no one, not even Microsoft, can decrypt them. Once you have encrypted your agent definition, it
     * will always remain encrypted. The search service will ignore attempts to set this property to null. You can
     * change this property as needed if you want to rotate your encryption key; Your agent definition will be
     * unaffected. Encryption with customer-managed keys is not available for free search services, and is only
     * available for paid services created on or after January 1, 2019.
     * 
     * @param encryptionKey the encryptionKey value to set.
     * @return the KnowledgeSource object itself.
     */
    @Generated
    public KnowledgeSource setEncryptionKey(SearchResourceEncryptionKey encryptionKey) {
        this.encryptionKey = encryptionKey;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("@odata.etag", this.eTag);
        jsonWriter.writeJsonField("encryptionKey", this.encryptionKey);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeSource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeSource if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KnowledgeSource.
     */
    @Generated
    public static KnowledgeSource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                readerToUse.nextToken(); // Prepare for reading
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("kind".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("searchIndex".equals(discriminatorValue)) {
                    return SearchIndexKnowledgeSource.fromJson(readerToUse.reset());
                } else if ("azureBlob".equals(discriminatorValue)) {
                    return AzureBlobKnowledgeSource.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    @Generated
    static KnowledgeSource fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            KnowledgeSourceKind kind = null;
            String description = null;
            String eTag = null;
            SearchResourceEncryptionKey encryptionKey = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                } else if ("kind".equals(fieldName)) {
                    kind = KnowledgeSourceKind.fromString(reader.getString());
                } else if ("description".equals(fieldName)) {
                    description = reader.getString();
                } else if ("@odata.etag".equals(fieldName)) {
                    eTag = reader.getString();
                } else if ("encryptionKey".equals(fieldName)) {
                    encryptionKey = SearchResourceEncryptionKey.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            if (nameFound) {
                KnowledgeSource deserializedKnowledgeSource = new KnowledgeSource(name);
                deserializedKnowledgeSource.kind = kind;
                deserializedKnowledgeSource.description = description;
                deserializedKnowledgeSource.eTag = eTag;
                deserializedKnowledgeSource.encryptionKey = encryptionKey;

                return deserializedKnowledgeSource;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}
