// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Base type for normalizers.
 */
@Immutable
public class LexicalNormalizer implements JsonSerializable<LexicalNormalizer> {
    /*
     * A URI fragment specifying the type of normalizer.
     */
    @Generated
    private String odataType = "LexicalNormalizer";

    /*
     * The name of the normalizer. It must only contain letters, digits, spaces, dashes or underscores, can only start
     * and end with alphanumeric characters, and is limited to 128 characters. It cannot end in '.microsoft' nor
     * '.lucene', nor be named 'asciifolding', 'standard', 'lowercase', 'uppercase', or 'elision'.
     */
    @Generated
    private final String name;

    /**
     * Creates an instance of LexicalNormalizer class.
     * 
     * @param name the name value to set.
     */
    @Generated
    public LexicalNormalizer(String name) {
        this.name = name;
    }

    /**
     * Get the odataType property: A URI fragment specifying the type of normalizer.
     * 
     * @return the odataType value.
     */
    @Generated
    public String getOdataType() {
        return this.odataType;
    }

    /**
     * Get the name property: The name of the normalizer. It must only contain letters, digits, spaces, dashes or
     * underscores, can only start and end with alphanumeric characters, and is limited to 128 characters. It cannot end
     * in '.microsoft' nor '.lucene', nor be named 'asciifolding', 'standard', 'lowercase', 'uppercase', or 'elision'.
     * 
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("@odata.type", this.odataType);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LexicalNormalizer from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LexicalNormalizer if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the LexicalNormalizer.
     */
    @Generated
    public static LexicalNormalizer fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                readerToUse.nextToken(); // Prepare for reading
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("@odata.type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("#Microsoft.Azure.Search.CustomNormalizer".equals(discriminatorValue)) {
                    return CustomNormalizer.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    @Generated
    static LexicalNormalizer fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String odataType = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                } else if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            if (nameFound) {
                LexicalNormalizer deserializedLexicalNormalizer = new LexicalNormalizer(name);
                deserializedLexicalNormalizer.odataType = odataType;

                return deserializedLexicalNormalizer;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}
