// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.implementation.models.KeywordTokenizerV1;
import com.azure.search.documents.indexes.implementation.models.KeywordTokenizerV2;
import com.azure.search.documents.indexes.implementation.models.LuceneStandardTokenizerV1;
import com.azure.search.documents.indexes.implementation.models.LuceneStandardTokenizerV2;
import java.io.IOException;

/**
 * Base type for tokenizers.
 */
@Immutable
public class LexicalTokenizer implements JsonSerializable<LexicalTokenizer> {
    /*
     * A URI fragment specifying the type of tokenizer.
     */
    @Generated
    private String odataType = "LexicalTokenizer";

    /*
     * The name of the tokenizer. It must only contain letters, digits, spaces, dashes or underscores, can only start
     * and end with alphanumeric characters, and is limited to 128 characters.
     */
    @Generated
    private final String name;

    /**
     * Creates an instance of LexicalTokenizer class.
     * 
     * @param name the name value to set.
     */
    @Generated
    public LexicalTokenizer(String name) {
        this.name = name;
    }

    /**
     * Get the odataType property: A URI fragment specifying the type of tokenizer.
     * 
     * @return the odataType value.
     */
    @Generated
    public String getOdataType() {
        return this.odataType;
    }

    /**
     * Get the name property: The name of the tokenizer. It must only contain letters, digits, spaces, dashes or
     * underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
     * 
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("@odata.type", this.odataType);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LexicalTokenizer from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LexicalTokenizer if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the LexicalTokenizer.
     */
    @Generated
    public static LexicalTokenizer fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                readerToUse.nextToken(); // Prepare for reading
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("@odata.type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("#Microsoft.Azure.Search.ClassicTokenizer".equals(discriminatorValue)) {
                    return ClassicTokenizer.fromJson(readerToUse.reset());
                } else if ("#Microsoft.Azure.Search.EdgeNGramTokenizer".equals(discriminatorValue)) {
                    return EdgeNGramTokenizer.fromJson(readerToUse.reset());
                } else if ("#Microsoft.Azure.Search.KeywordTokenizerV2".equals(discriminatorValue)) {
                    return KeywordTokenizerV2.fromJson(readerToUse.reset());
                } else if ("#Microsoft.Azure.Search.MicrosoftLanguageTokenizer".equals(discriminatorValue)) {
                    return MicrosoftLanguageTokenizer.fromJson(readerToUse.reset());
                } else if ("#Microsoft.Azure.Search.MicrosoftLanguageStemmingTokenizer".equals(discriminatorValue)) {
                    return MicrosoftLanguageStemmingTokenizer.fromJson(readerToUse.reset());
                } else if ("#Microsoft.Azure.Search.NGramTokenizer".equals(discriminatorValue)) {
                    return NGramTokenizer.fromJson(readerToUse.reset());
                } else if ("#Microsoft.Azure.Search.PatternTokenizer".equals(discriminatorValue)) {
                    return PatternTokenizer.fromJson(readerToUse.reset());
                } else if ("#Microsoft.Azure.Search.StandardTokenizerV2".equals(discriminatorValue)) {
                    return LuceneStandardTokenizerV2.fromJson(readerToUse.reset());
                } else if ("#Microsoft.Azure.Search.UaxUrlEmailTokenizer".equals(discriminatorValue)) {
                    return UaxUrlEmailTokenizer.fromJson(readerToUse.reset());
                } else if ("#Microsoft.Azure.Search.PathHierarchyTokenizerV2".equals(discriminatorValue)) {
                    return PathHierarchyTokenizer.fromJson(readerToUse.reset());
                } else if ("#Microsoft.Azure.Search.StandardTokenizer".equals(discriminatorValue)) {
                    return LuceneStandardTokenizerV1.fromJson(readerToUse.reset());
                } else if ("#Microsoft.Azure.Search.KeywordTokenizer".equals(discriminatorValue)) {
                    return KeywordTokenizerV1.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    @Generated
    static LexicalTokenizer fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String odataType = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                } else if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            if (nameFound) {
                LexicalTokenizer deserializedLexicalTokenizer = new LexicalTokenizer(name);
                deserializedLexicalTokenizer.odataType = odataType;

                return deserializedLexicalTokenizer;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}
