// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Specifies the max header depth that will be considered while grouping markdown content. Default is `h6`.
 */
public final class MarkdownHeaderDepth extends ExpandableStringEnum<MarkdownHeaderDepth> {
    /**
     * Indicates that headers up to a level of h1 will be considered while grouping markdown content.
     */
    @Generated
    public static final MarkdownHeaderDepth H1 = fromString("h1");

    /**
     * Indicates that headers up to a level of h2 will be considered while grouping markdown content.
     */
    @Generated
    public static final MarkdownHeaderDepth H2 = fromString("h2");

    /**
     * Indicates that headers up to a level of h3 will be considered while grouping markdown content.
     */
    @Generated
    public static final MarkdownHeaderDepth H3 = fromString("h3");

    /**
     * Indicates that headers up to a level of h4 will be considered while grouping markdown content.
     */
    @Generated
    public static final MarkdownHeaderDepth H4 = fromString("h4");

    /**
     * Indicates that headers up to a level of h5 will be considered while grouping markdown content.
     */
    @Generated
    public static final MarkdownHeaderDepth H5 = fromString("h5");

    /**
     * Indicates that headers up to a level of h6 will be considered while grouping markdown content. This is the
     * default.
     */
    @Generated
    public static final MarkdownHeaderDepth H6 = fromString("h6");

    /**
     * Creates a new instance of MarkdownHeaderDepth value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public MarkdownHeaderDepth() {
    }

    /**
     * Creates or finds a MarkdownHeaderDepth from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding MarkdownHeaderDepth.
     */
    @Generated
    public static MarkdownHeaderDepth fromString(String name) {
        return fromString(name, MarkdownHeaderDepth.class);
    }

    /**
     * Gets known MarkdownHeaderDepth values.
     * 
     * @return known MarkdownHeaderDepth values.
     */
    @Generated
    public static Collection<MarkdownHeaderDepth> values() {
        return values(MarkdownHeaderDepth.class);
    }
}
