// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Specifies the submode that will determine whether a markdown file will be parsed into exactly one search document or
 * multiple search documents. Default is `oneToMany`.
 */
public final class MarkdownParsingSubmode extends ExpandableStringEnum<MarkdownParsingSubmode> {
    /**
     * Indicates that each section of the markdown file (up to a specified depth) will be parsed into individual search
     * documents. This can result in a single markdown file producing multiple search documents. This is the default
     * sub-mode.
     */
    @Generated
    public static final MarkdownParsingSubmode ONE_TO_MANY = fromString("oneToMany");

    /**
     * Indicates that each markdown file will be parsed into a single search document.
     */
    @Generated
    public static final MarkdownParsingSubmode ONE_TO_ONE = fromString("oneToOne");

    /**
     * Creates a new instance of MarkdownParsingSubmode value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public MarkdownParsingSubmode() {
    }

    /**
     * Creates or finds a MarkdownParsingSubmode from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding MarkdownParsingSubmode.
     */
    @Generated
    public static MarkdownParsingSubmode fromString(String name) {
        return fromString(name, MarkdownParsingSubmode.class);
    }

    /**
     * Gets known MarkdownParsingSubmode values.
     * 
     * @return known MarkdownParsingSubmode values.
     */
    @Generated
    public static Collection<MarkdownParsingSubmode> values() {
        return values(MarkdownParsingSubmode.class);
    }
}
