// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Knowledge Source targeting a search index.
 */
@Fluent
public final class SearchIndexKnowledgeSource extends KnowledgeSource {
    /*
     * The type of the knowledge source.
     */
    @Generated
    private KnowledgeSourceKind kind = KnowledgeSourceKind.SEARCH_INDEX;

    /*
     * The parameters for the knowledge source.
     */
    @Generated
    private final SearchIndexKnowledgeSourceParameters searchIndexParameters;

    /**
     * Creates an instance of SearchIndexKnowledgeSource class.
     * 
     * @param name the name value to set.
     * @param searchIndexParameters the searchIndexParameters value to set.
     */
    @Generated
    public SearchIndexKnowledgeSource(String name, SearchIndexKnowledgeSourceParameters searchIndexParameters) {
        super(name);
        this.searchIndexParameters = searchIndexParameters;
    }

    /**
     * Get the kind property: The type of the knowledge source.
     * 
     * @return the kind value.
     */
    @Generated
    @Override
    public KnowledgeSourceKind getKind() {
        return this.kind;
    }

    /**
     * Get the searchIndexParameters property: The parameters for the knowledge source.
     * 
     * @return the searchIndexParameters value.
     */
    @Generated
    public SearchIndexKnowledgeSourceParameters getSearchIndexParameters() {
        return this.searchIndexParameters;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public SearchIndexKnowledgeSource setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public SearchIndexKnowledgeSource setETag(String eTag) {
        super.setETag(eTag);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public SearchIndexKnowledgeSource setEncryptionKey(SearchResourceEncryptionKey encryptionKey) {
        super.setEncryptionKey(encryptionKey);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", getName());
        jsonWriter.writeStringField("description", getDescription());
        jsonWriter.writeStringField("@odata.etag", getETag());
        jsonWriter.writeJsonField("encryptionKey", getEncryptionKey());
        jsonWriter.writeJsonField("searchIndexParameters", this.searchIndexParameters);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SearchIndexKnowledgeSource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SearchIndexKnowledgeSource if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SearchIndexKnowledgeSource.
     */
    @Generated
    public static SearchIndexKnowledgeSource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String description = null;
            String eTag = null;
            SearchResourceEncryptionKey encryptionKey = null;
            boolean searchIndexParametersFound = false;
            SearchIndexKnowledgeSourceParameters searchIndexParameters = null;
            KnowledgeSourceKind kind = KnowledgeSourceKind.SEARCH_INDEX;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                } else if ("description".equals(fieldName)) {
                    description = reader.getString();
                } else if ("@odata.etag".equals(fieldName)) {
                    eTag = reader.getString();
                } else if ("encryptionKey".equals(fieldName)) {
                    encryptionKey = SearchResourceEncryptionKey.fromJson(reader);
                } else if ("searchIndexParameters".equals(fieldName)) {
                    searchIndexParameters = SearchIndexKnowledgeSourceParameters.fromJson(reader);
                    searchIndexParametersFound = true;
                } else if ("kind".equals(fieldName)) {
                    kind = KnowledgeSourceKind.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            if (nameFound && searchIndexParametersFound) {
                SearchIndexKnowledgeSource deserializedSearchIndexKnowledgeSource
                    = new SearchIndexKnowledgeSource(name, searchIndexParameters);
                deserializedSearchIndexKnowledgeSource.setDescription(description);
                deserializedSearchIndexKnowledgeSource.setETag(eTag);
                deserializedSearchIndexKnowledgeSource.setEncryptionKey(encryptionKey);
                deserializedSearchIndexKnowledgeSource.kind = kind;

                return deserializedSearchIndexKnowledgeSource;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!searchIndexParametersFound) {
                missingProperties.add("searchIndexParameters");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
