// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Parameters for search index knowledge source.
 */
@Fluent
public final class SearchIndexKnowledgeSourceParameters
    implements JsonSerializable<SearchIndexKnowledgeSourceParameters> {
    /*
     * The name of the Search index.
     */
    @Generated
    private final String searchIndexName;

    /*
     * Used to request additional fields for referenced source data.
     */
    @Generated
    private String sourceDataSelect;

    /**
     * Creates an instance of SearchIndexKnowledgeSourceParameters class.
     * 
     * @param searchIndexName the searchIndexName value to set.
     */
    @Generated
    public SearchIndexKnowledgeSourceParameters(String searchIndexName) {
        this.searchIndexName = searchIndexName;
    }

    /**
     * Get the searchIndexName property: The name of the Search index.
     * 
     * @return the searchIndexName value.
     */
    @Generated
    public String getSearchIndexName() {
        return this.searchIndexName;
    }

    /**
     * Get the sourceDataSelect property: Used to request additional fields for referenced source data.
     * 
     * @return the sourceDataSelect value.
     */
    @Generated
    public String getSourceDataSelect() {
        return this.sourceDataSelect;
    }

    /**
     * Set the sourceDataSelect property: Used to request additional fields for referenced source data.
     * 
     * @param sourceDataSelect the sourceDataSelect value to set.
     * @return the SearchIndexKnowledgeSourceParameters object itself.
     */
    @Generated
    public SearchIndexKnowledgeSourceParameters setSourceDataSelect(String sourceDataSelect) {
        this.sourceDataSelect = sourceDataSelect;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("searchIndexName", this.searchIndexName);
        jsonWriter.writeStringField("sourceDataSelect", this.sourceDataSelect);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SearchIndexKnowledgeSourceParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SearchIndexKnowledgeSourceParameters if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SearchIndexKnowledgeSourceParameters.
     */
    @Generated
    public static SearchIndexKnowledgeSourceParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean searchIndexNameFound = false;
            String searchIndexName = null;
            String sourceDataSelect = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("searchIndexName".equals(fieldName)) {
                    searchIndexName = reader.getString();
                    searchIndexNameFound = true;
                } else if ("sourceDataSelect".equals(fieldName)) {
                    sourceDataSelect = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            if (searchIndexNameFound) {
                SearchIndexKnowledgeSourceParameters deserializedSearchIndexKnowledgeSourceParameters
                    = new SearchIndexKnowledgeSourceParameters(searchIndexName);
                deserializedSearchIndexKnowledgeSourceParameters.sourceDataSelect = sourceDataSelect;

                return deserializedSearchIndexKnowledgeSourceParameters;
            }
            throw new IllegalStateException("Missing required property: searchIndexName");
        });
    }
}
