// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Clears the identity property of a datasource.
 */
@Immutable
public final class SearchIndexerDataNoneIdentity extends SearchIndexerDataIdentity {
    /*
     * A URI fragment specifying the type of identity.
     */
    @Generated
    private String odataType = "#Microsoft.Azure.Search.DataNoneIdentity";

    /**
     * Creates an instance of SearchIndexerDataNoneIdentity class.
     */
    @Generated
    public SearchIndexerDataNoneIdentity() {
    }

    /**
     * Get the odataType property: A URI fragment specifying the type of identity.
     * 
     * @return the odataType value.
     */
    @Generated
    @Override
    public String getOdataType() {
        return this.odataType;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", this.odataType);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SearchIndexerDataNoneIdentity from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SearchIndexerDataNoneIdentity if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SearchIndexerDataNoneIdentity.
     */
    @Generated
    public static SearchIndexerDataNoneIdentity fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SearchIndexerDataNoneIdentity deserializedSearchIndexerDataNoneIdentity
                = new SearchIndexerDataNoneIdentity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("@odata.type".equals(fieldName)) {
                    deserializedSearchIndexerDataNoneIdentity.odataType = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSearchIndexerDataNoneIdentity;
        });
    }
}
