// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Defines the type of a datasource.
 */
public final class SearchIndexerDataSourceType extends ExpandableStringEnum<SearchIndexerDataSourceType> {
    /**
     * Indicates an Azure SQL datasource.
     */
    @Generated
    public static final SearchIndexerDataSourceType AZURE_SQL = fromString("azuresql");

    /**
     * Indicates a CosmosDB datasource.
     */
    @Generated
    public static final SearchIndexerDataSourceType COSMOS_DB = fromString("cosmosdb");

    /**
     * Indicates an Azure Blob datasource.
     */
    @Generated
    public static final SearchIndexerDataSourceType AZURE_BLOB = fromString("azureblob");

    /**
     * Indicates an Azure Table datasource.
     */
    @Generated
    public static final SearchIndexerDataSourceType AZURE_TABLE = fromString("azuretable");

    /**
     * Indicates a MySql datasource.
     */
    @Generated
    public static final SearchIndexerDataSourceType MY_SQL = fromString("mysql");

    /**
     * Indicates an ADLS Gen2 datasource.
     */
    @Generated
    public static final SearchIndexerDataSourceType ADLS_GEN2 = fromString("adlsgen2");

    /**
     * Indicates a Microsoft Fabric OneLake datasource.
     */
    @Generated
    public static final SearchIndexerDataSourceType ONE_LAKE = fromString("onelake");

    /**
     * Creates a new instance of SearchIndexerDataSourceType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public SearchIndexerDataSourceType() {
    }

    /**
     * Creates or finds a SearchIndexerDataSourceType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding SearchIndexerDataSourceType.
     */
    @Generated
    public static SearchIndexerDataSourceType fromString(String name) {
        return fromString(name, SearchIndexerDataSourceType.class);
    }

    /**
     * Gets known SearchIndexerDataSourceType values.
     * 
     * @return known SearchIndexerDataSourceType values.
     */
    @Generated
    public static Collection<SearchIndexerDataSourceType> values() {
        return values(SearchIndexerDataSourceType.class);
    }
}
