// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Abstract class to share properties between concrete selectors.
 */
@Fluent
public class SearchIndexerKnowledgeStoreBlobProjectionSelector extends SearchIndexerKnowledgeStoreProjectionSelector {

    /*
     * Blob container to store projections in.
     */
    @Generated
    private final String storageContainer;

    /**
     * Creates an instance of SearchIndexerKnowledgeStoreBlobProjectionSelector class.
     *
     * @param storageContainer the storageContainer value to set.
     */
    @Generated
    public SearchIndexerKnowledgeStoreBlobProjectionSelector(String storageContainer) {
        this.storageContainer = storageContainer;
    }

    /**
     * Get the storageContainer property: Blob container to store projections in.
     *
     * @return the storageContainer value.
     */
    @Generated
    public String getStorageContainer() {
        return this.storageContainer;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public SearchIndexerKnowledgeStoreBlobProjectionSelector setReferenceKeyName(String referenceKeyName) {
        super.setReferenceKeyName(referenceKeyName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public SearchIndexerKnowledgeStoreBlobProjectionSelector setGeneratedKeyName(String generatedKeyName) {
        super.setGeneratedKeyName(generatedKeyName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public SearchIndexerKnowledgeStoreBlobProjectionSelector setSource(String source) {
        super.setSource(source);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public SearchIndexerKnowledgeStoreBlobProjectionSelector setSourceContext(String sourceContext) {
        super.setSourceContext(sourceContext);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public SearchIndexerKnowledgeStoreBlobProjectionSelector setInputs(List<InputFieldMappingEntry> inputs) {
        super.setInputs(inputs);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("referenceKeyName", getReferenceKeyName());
        jsonWriter.writeStringField("generatedKeyName", getGeneratedKeyName());
        jsonWriter.writeStringField("source", getSource());
        jsonWriter.writeStringField("sourceContext", getSourceContext());
        jsonWriter.writeArrayField("inputs", getInputs(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("storageContainer", this.storageContainer);
        return jsonWriter.writeEndObject();
    }
}
