// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Description for what data to store in Azure Tables.
 */
@Fluent
public final class SearchIndexerKnowledgeStoreTableProjectionSelector
    extends SearchIndexerKnowledgeStoreProjectionSelector {
    /*
     * Name of the Azure table to store projected data in.
     */
    @Generated
    private final String tableName;

    /**
     * Creates an instance of SearchIndexerKnowledgeStoreTableProjectionSelector class.
     * 
     * @param tableName the tableName value to set.
     */
    @Generated
    public SearchIndexerKnowledgeStoreTableProjectionSelector(String tableName) {
        this.tableName = tableName;
    }

    /**
     * Get the tableName property: Name of the Azure table to store projected data in.
     * 
     * @return the tableName value.
     */
    @Generated
    public String getTableName() {
        return this.tableName;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public SearchIndexerKnowledgeStoreTableProjectionSelector setReferenceKeyName(String referenceKeyName) {
        super.setReferenceKeyName(referenceKeyName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public SearchIndexerKnowledgeStoreTableProjectionSelector setGeneratedKeyName(String generatedKeyName) {
        super.setGeneratedKeyName(generatedKeyName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public SearchIndexerKnowledgeStoreTableProjectionSelector setSource(String source) {
        super.setSource(source);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public SearchIndexerKnowledgeStoreTableProjectionSelector setSourceContext(String sourceContext) {
        super.setSourceContext(sourceContext);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public SearchIndexerKnowledgeStoreTableProjectionSelector setInputs(List<InputFieldMappingEntry> inputs) {
        super.setInputs(inputs);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("referenceKeyName", getReferenceKeyName());
        jsonWriter.writeStringField("generatedKeyName", getGeneratedKeyName());
        jsonWriter.writeStringField("source", getSource());
        jsonWriter.writeStringField("sourceContext", getSourceContext());
        jsonWriter.writeArrayField("inputs", getInputs(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("tableName", this.tableName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SearchIndexerKnowledgeStoreTableProjectionSelector from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SearchIndexerKnowledgeStoreTableProjectionSelector if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SearchIndexerKnowledgeStoreTableProjectionSelector.
     */
    @Generated
    public static SearchIndexerKnowledgeStoreTableProjectionSelector fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            String referenceKeyName = null;
            String generatedKeyName = null;
            String source = null;
            String sourceContext = null;
            List<InputFieldMappingEntry> inputs = null;
            boolean tableNameFound = false;
            String tableName = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("referenceKeyName".equals(fieldName)) {
                    referenceKeyName = reader.getString();
                } else if ("generatedKeyName".equals(fieldName)) {
                    generatedKeyName = reader.getString();
                } else if ("source".equals(fieldName)) {
                    source = reader.getString();
                } else if ("sourceContext".equals(fieldName)) {
                    sourceContext = reader.getString();
                } else if ("inputs".equals(fieldName)) {
                    inputs = reader.readArray(reader1 -> InputFieldMappingEntry.fromJson(reader1));
                } else if ("tableName".equals(fieldName)) {
                    tableName = reader.getString();
                    tableNameFound = true;
                } else {
                    reader.skipChildren();
                }
            }
            if (tableNameFound) {
                SearchIndexerKnowledgeStoreTableProjectionSelector deserializedSearchIndexerKnowledgeStoreTableProjectionSelector
                    = new SearchIndexerKnowledgeStoreTableProjectionSelector(tableName);
                deserializedSearchIndexerKnowledgeStoreTableProjectionSelector.setReferenceKeyName(referenceKeyName);
                deserializedSearchIndexerKnowledgeStoreTableProjectionSelector.setGeneratedKeyName(generatedKeyName);
                deserializedSearchIndexerKnowledgeStoreTableProjectionSelector.setSource(source);
                deserializedSearchIndexerKnowledgeStoreTableProjectionSelector.setSourceContext(sourceContext);
                deserializedSearchIndexerKnowledgeStoreTableProjectionSelector.setInputs(inputs);

                return deserializedSearchIndexerKnowledgeStoreTableProjectionSelector;
            }
            throw new IllegalStateException("Missing required property: tableName");
        });
    }
}
