// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;

/**
 * The SearchIndexerLimits model.
 */
@Immutable
public final class SearchIndexerLimits implements JsonSerializable<SearchIndexerLimits> {
    /*
     * The maximum duration that the indexer is permitted to run for one execution.
     */
    @Generated
    private Duration maxRunTime;

    /*
     * The maximum size of a document, in bytes, which will be considered valid for indexing.
     */
    @Generated
    private Long maxDocumentExtractionSize;

    /*
     * The maximum number of characters that will be extracted from a document picked up for indexing.
     */
    @Generated
    private Long maxDocumentContentCharactersToExtract;

    /**
     * Creates an instance of SearchIndexerLimits class.
     */
    @Generated
    public SearchIndexerLimits() {
    }

    /**
     * Get the maxRunTime property: The maximum duration that the indexer is permitted to run for one execution.
     * 
     * @return the maxRunTime value.
     */
    @Generated
    public Duration getMaxRunTime() {
        return this.maxRunTime;
    }

    /**
     * Get the maxDocumentExtractionSize property: The maximum size of a document, in bytes, which will be considered
     * valid for indexing.
     * 
     * @return the maxDocumentExtractionSize value.
     */
    @Generated
    public Long getMaxDocumentExtractionSize() {
        return this.maxDocumentExtractionSize;
    }

    /**
     * Get the maxDocumentContentCharactersToExtract property: The maximum number of characters that will be extracted
     * from a document picked up for indexing.
     * 
     * @return the maxDocumentContentCharactersToExtract value.
     */
    @Generated
    public Long getMaxDocumentContentCharactersToExtract() {
        return this.maxDocumentContentCharactersToExtract;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SearchIndexerLimits from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SearchIndexerLimits if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the SearchIndexerLimits.
     */
    @Generated
    public static SearchIndexerLimits fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SearchIndexerLimits deserializedSearchIndexerLimits = new SearchIndexerLimits();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("maxRunTime".equals(fieldName)) {
                    deserializedSearchIndexerLimits.maxRunTime
                        = reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                } else if ("maxDocumentExtractionSize".equals(fieldName)) {
                    deserializedSearchIndexerLimits.maxDocumentExtractionSize = reader.getNullable(JsonReader::getLong);
                } else if ("maxDocumentContentCharactersToExtract".equals(fieldName)) {
                    deserializedSearchIndexerLimits.maxDocumentContentCharactersToExtract
                        = reader.getNullable(JsonReader::getLong);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSearchIndexerLimits;
        });
    }
}
