// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.implementation.models.AzureActiveDirectoryApplicationCredentials;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * A customer-managed encryption key in Azure Key Vault. Keys that you create and manage can be used to encrypt or
 * decrypt data-at-rest, such as indexes and synonym maps.
 */
@Fluent
public final class SearchResourceEncryptionKey implements JsonSerializable<SearchResourceEncryptionKey> {

    /*
     * The name of your Azure Key Vault key to be used to encrypt your data at rest.
     */
    @Generated
    private final String keyName;

    /*
     * The version of your Azure Key Vault key to be used to encrypt your data at rest.
     */
    @Generated
    private String keyVersion;

    /*
     * The URI of your Azure Key Vault, also referred to as DNS name, that contains the key to be used to encrypt your
     * data at rest. An example URI might be `https://my-keyvault-name.vault.azure.net`.
     */
    @Generated
    private final String vaultUrl;

    /*
     * Optional Azure Active Directory credentials used for accessing your Azure Key Vault. Not required if using
     * managed identity instead.
     */
    @Generated
    private AzureActiveDirectoryApplicationCredentials accessCredentials;

    /*
     * An explicit managed identity to use for this encryption key. If not specified and the access credentials property
     * is null, the system-assigned managed identity is used. On update to the resource, if the explicit identity is
     * unspecified, it remains unchanged. If "none" is specified, the value of this property is cleared.
     */
    @Generated
    private SearchIndexerDataIdentity identity;

    /**
     * Creates an instance of SearchResourceEncryptionKey class.
     *
     * @param keyName the keyName value to set.
     * @param vaultUrl the vaultUrl value to set.
     */
    @Generated
    public SearchResourceEncryptionKey(String keyName, String vaultUrl) {
        this.keyName = keyName;
        this.vaultUrl = vaultUrl;
    }

    /**
     * Get the keyName property: The name of your Azure Key Vault key to be used to encrypt your data at rest.
     *
     * @return the keyName value.
     */
    @Generated
    public String getKeyName() {
        return this.keyName;
    }

    /**
     * Get the keyVersion property: The version of your Azure Key Vault key to be used to encrypt your data at rest.
     *
     * @return the keyVersion value.
     */
    @Generated
    public String getKeyVersion() {
        return this.keyVersion;
    }

    /**
     * Set the keyVersion property: The version of your Azure Key Vault key to be used to encrypt your data at rest.
     *
     * @param keyVersion the keyVersion value to set.
     * @return the SearchResourceEncryptionKey object itself.
     */
    @Generated
    public SearchResourceEncryptionKey setKeyVersion(String keyVersion) {
        this.keyVersion = keyVersion;
        return this;
    }

    /**
     * Get the vaultUrl property: The URI of your Azure Key Vault, also referred to as DNS name, that contains the key
     * to be used to encrypt your data at rest. An example URI might be `https://my-keyvault-name.vault.azure.net`.
     *
     * @return the vaultUrl value.
     */
    @Generated
    public String getVaultUrl() {
        return this.vaultUrl;
    }

    /**
     * Get the identity property: An explicit managed identity to use for this encryption key. If not specified and the
     * access credentials property is null, the system-assigned managed identity is used. On update to the resource, if
     * the explicit identity is unspecified, it remains unchanged. If "none" is specified, the value of this property is
     * cleared.
     *
     * @return the identity value.
     */
    @Generated
    public SearchIndexerDataIdentity getIdentity() {
        return this.identity;
    }

    /**
     * Set the identity property: An explicit managed identity to use for this encryption key. If not specified and the
     * access credentials property is null, the system-assigned managed identity is used. On update to the resource, if
     * the explicit identity is unspecified, it remains unchanged. If "none" is specified, the value of this property is
     * cleared.
     *
     * @param identity the identity value to set.
     * @return the SearchResourceEncryptionKey object itself.
     */
    @Generated
    public SearchResourceEncryptionKey setIdentity(SearchIndexerDataIdentity identity) {
        this.identity = identity;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keyVaultKeyName", this.keyName);
        jsonWriter.writeStringField("keyVaultUri", this.vaultUrl);
        jsonWriter.writeStringField("keyVaultKeyVersion", this.keyVersion);
        jsonWriter.writeJsonField("accessCredentials", this.accessCredentials);
        jsonWriter.writeJsonField("identity", this.identity);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SearchResourceEncryptionKey from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of SearchResourceEncryptionKey if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SearchResourceEncryptionKey.
     */
    @Generated
    public static SearchResourceEncryptionKey fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean keyNameFound = false;
            String keyName = null;
            boolean vaultUrlFound = false;
            String vaultUrl = null;
            String keyVersion = null;
            AzureActiveDirectoryApplicationCredentials accessCredentials = null;
            SearchIndexerDataIdentity identity = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keyVaultKeyName".equals(fieldName)) {
                    keyName = reader.getString();
                    keyNameFound = true;
                } else if ("keyVaultUri".equals(fieldName)) {
                    vaultUrl = reader.getString();
                    vaultUrlFound = true;
                } else if ("keyVaultKeyVersion".equals(fieldName)) {
                    keyVersion = reader.getString();
                } else if ("accessCredentials".equals(fieldName)) {
                    accessCredentials = AzureActiveDirectoryApplicationCredentials.fromJson(reader);
                } else if ("identity".equals(fieldName)) {
                    identity = SearchIndexerDataIdentity.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            if (keyNameFound && vaultUrlFound) {
                SearchResourceEncryptionKey deserializedSearchResourceEncryptionKey
                    = new SearchResourceEncryptionKey(keyName, vaultUrl);
                deserializedSearchResourceEncryptionKey.keyVersion = keyVersion;
                deserializedSearchResourceEncryptionKey.accessCredentials = accessCredentials;
                deserializedSearchResourceEncryptionKey.identity = identity;
                return deserializedSearchResourceEncryptionKey;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!keyNameFound) {
                missingProperties.add("keyVaultKeyName");
            }
            if (!vaultUrlFound) {
                missingProperties.add("keyVaultUri");
            }
            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }

    /**
     * Get the applicationId property: An AAD Application ID that was granted the required access permissions to the
     * Azure Key Vault that is to be used when encrypting your data at rest. The Application ID should not be confused
     * with the Object ID for your AAD Application.
     *
     * @return the applicationId value.
     */
    public String getApplicationId() {
        return (this.accessCredentials == null) ? null : this.accessCredentials.getApplicationId();
    }

    /**
     * Set the applicationId property: An AAD Application ID that was granted the required access permissions to the
     * Azure Key Vault that is to be used when encrypting your data at rest. The Application ID should not be confused
     * with the Object ID for your AAD Application.
     *
     * @param applicationId the applicationId value to set.
     * @return the SearchResourceEncryptionKey object itself.
     */
    public SearchResourceEncryptionKey setApplicationId(String applicationId) {
        if (this.accessCredentials == null) {
            this.accessCredentials = new AzureActiveDirectoryApplicationCredentials();
        }
        this.accessCredentials.setApplicationId(applicationId);
        return this;
    }

    /**
     * Get the applicationSecret property: The authentication key of the specified AAD application.
     *
     * @return the applicationSecret value.
     */
    public String getApplicationSecret() {
        return (this.accessCredentials == null) ? null : this.accessCredentials.getApplicationSecret();
    }

    /**
     * Set the applicationSecret property: The authentication key of the specified AAD application.
     *
     * @param applicationSecret the applicationSecret value to set.
     * @return the SearchResourceEncryptionKey object itself.
     */
    public SearchResourceEncryptionKey setApplicationSecret(String applicationSecret) {
        if (this.accessCredentials == null) {
            this.accessCredentials = new AzureActiveDirectoryApplicationCredentials();
        }
        this.accessCredentials.setApplicationSecret(applicationSecret);
        return this;
    }
}
