// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

/**
 * Describes the title, content, and keywords fields to be used for semantic ranking, captions, highlights, and answers.
 */
@Fluent
public final class SemanticPrioritizedFields implements JsonSerializable<SemanticPrioritizedFields> {

    /*
     * Defines the title field to be used for semantic ranking, captions, highlights, and answers. If you don't have a
     * title field in your index, leave this blank.
     */
    @Generated
    private SemanticField titleField;

    /*
     * Defines the content fields to be used for semantic ranking, captions, highlights, and answers. For the best
     * result, the selected fields should contain text in natural language form. The order of the fields in the array
     * represents their priority. Fields with lower priority may get truncated if the content is long.
     */
    @Generated
    private List<SemanticField> contentFields;

    /*
     * Defines the keyword fields to be used for semantic ranking, captions, highlights, and answers. For the best
     * result, the selected fields should contain a list of keywords. The order of the fields in the array represents
     * their priority. Fields with lower priority may get truncated if the content is long.
     */
    @Generated
    private List<SemanticField> keywordsFields;

    /**
     * Creates an instance of SemanticPrioritizedFields class.
     */
    @Generated
    public SemanticPrioritizedFields() {
    }

    /**
     * Get the titleField property: Defines the title field to be used for semantic ranking, captions, highlights, and
     * answers. If you don't have a title field in your index, leave this blank.
     *
     * @return the titleField value.
     */
    @Generated
    public SemanticField getTitleField() {
        return this.titleField;
    }

    /**
     * Set the titleField property: Defines the title field to be used for semantic ranking, captions, highlights, and
     * answers. If you don't have a title field in your index, leave this blank.
     *
     * @param titleField the titleField value to set.
     * @return the SemanticPrioritizedFields object itself.
     */
    @Generated
    public SemanticPrioritizedFields setTitleField(SemanticField titleField) {
        this.titleField = titleField;
        return this;
    }

    /**
     * Get the contentFields property: Defines the content fields to be used for semantic ranking, captions, highlights,
     * and answers. For the best result, the selected fields should contain text in natural language form. The order of
     * the fields in the array represents their priority. Fields with lower priority may get truncated if the content is
     * long.
     *
     * @return the contentFields value.
     */
    @Generated
    public List<SemanticField> getContentFields() {
        return this.contentFields;
    }

    /**
     * Set the contentFields property: Defines the content fields to be used for semantic ranking, captions, highlights,
     * and answers. For the best result, the selected fields should contain text in natural language form. The order of
     * the fields in the array represents their priority. Fields with lower priority may get truncated if the content is
     * long.
     *
     * @param contentFields the contentFields value to set.
     * @return the SemanticPrioritizedFields object itself.
     */
    @Generated
    public SemanticPrioritizedFields setContentFields(List<SemanticField> contentFields) {
        this.contentFields = contentFields;
        return this;
    }

    /**
     * Get the keywordsFields property: Defines the keyword fields to be used for semantic ranking, captions,
     * highlights, and answers. For the best result, the selected fields should contain a list of keywords. The order of
     * the fields in the array represents their priority. Fields with lower priority may get truncated if the content is
     * long.
     *
     * @return the keywordsFields value.
     */
    @Generated
    public List<SemanticField> getKeywordsFields() {
        return this.keywordsFields;
    }

    /**
     * Set the keywordsFields property: Defines the keyword fields to be used for semantic ranking, captions,
     * highlights, and answers. For the best result, the selected fields should contain a list of keywords. The order of
     * the fields in the array represents their priority. Fields with lower priority may get truncated if the content is
     * long.
     *
     * @param keywordsFields the keywordsFields value to set.
     * @return the SemanticPrioritizedFields object itself.
     */
    @Generated
    public SemanticPrioritizedFields setKeywordsFields(List<SemanticField> keywordsFields) {
        this.keywordsFields = keywordsFields;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("titleField", this.titleField);
        jsonWriter.writeArrayField("prioritizedContentFields", this.contentFields,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("prioritizedKeywordsFields", this.keywordsFields,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SemanticPrioritizedFields from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of SemanticPrioritizedFields if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SemanticPrioritizedFields.
     */
    @Generated
    public static SemanticPrioritizedFields fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SemanticPrioritizedFields deserializedSemanticPrioritizedFields = new SemanticPrioritizedFields();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("titleField".equals(fieldName)) {
                    deserializedSemanticPrioritizedFields.titleField = SemanticField.fromJson(reader);
                } else if ("prioritizedContentFields".equals(fieldName)) {
                    List<SemanticField> contentFields = reader.readArray(reader1 -> SemanticField.fromJson(reader1));
                    deserializedSemanticPrioritizedFields.contentFields = contentFields;
                } else if ("prioritizedKeywordsFields".equals(fieldName)) {
                    List<SemanticField> keywordsFields = reader.readArray(reader1 -> SemanticField.fromJson(reader1));
                    deserializedSemanticPrioritizedFields.keywordsFields = keywordsFields;
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedSemanticPrioritizedFields;
        });
    }

    /**
     * Set the contentFields property: Defines the content fields to be used for semantic ranking, captions, highlights,
     * and answers. For the best result, the selected fields should contain text in natural language form. The order of
     * the fields in the array represents their priority. Fields with lower priority may get truncated if the content is
     * long.
     *
     * @param contentFields the contentFields value to set.
     * @return the SemanticPrioritizedFields object itself.
     */
    public SemanticPrioritizedFields setContentFields(SemanticField... contentFields) {
        this.contentFields = (contentFields == null) ? null : Arrays.asList(contentFields);
        return this;
    }

    /**
     * Set the keywordsFields property: Defines the keyword fields to be used for semantic ranking, captions,
     * highlights, and answers. For the best result, the selected fields should contain a list of keywords. The order of
     * the fields in the array represents their priority. Fields with lower priority may get truncated if the content is
     * long.
     *
     * @param keywordsFields the keywordsFields value to set.
     * @return the SemanticPrioritizedFields object itself.
     */
    public SemanticPrioritizedFields setKeywordsFields(SemanticField... keywordsFields) {
        this.keywordsFields = (keywordsFields == null) ? null : Arrays.asList(keywordsFields);
        return this;
    }
}
