// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

/**
 * Removes stop words from a token stream. This token filter is implemented using Apache Lucene.
 */
@Fluent
public final class StopwordsTokenFilter extends TokenFilter {

    /*
     * A URI fragment specifying the type of token filter.
     */
    @Generated
    private String odataType = "#Microsoft.Azure.Search.StopwordsTokenFilter";

    /*
     * The list of stopwords. This property and the stopwords list property cannot both be set.
     */
    @Generated
    private List<String> stopwords;

    /*
     * A predefined list of stopwords to use. This property and the stopwords property cannot both be set. Default is
     * English.
     */
    @Generated
    private StopwordsList stopwordsList;

    /*
     * A value indicating whether to ignore case. If true, all words are converted to lower case first. Default is
     * false.
     */
    @Generated
    private Boolean caseIgnored;

    /*
     * A value indicating whether to ignore the last search term if it's a stop word. Default is true.
     */
    @Generated
    private Boolean trailingStopWordsRemoved;

    /**
     * Creates an instance of StopwordsTokenFilter class.
     *
     * @param name the name value to set.
     */
    @Generated
    public StopwordsTokenFilter(String name) {
        super(name);
    }

    /**
     * Get the odataType property: A URI fragment specifying the type of token filter.
     *
     * @return the odataType value.
     */
    @Generated
    @Override
    public String getOdataType() {
        return this.odataType;
    }

    /**
     * Get the stopwords property: The list of stopwords. This property and the stopwords list property cannot both be
     * set.
     *
     * @return the stopwords value.
     */
    @Generated
    public List<String> getStopwords() {
        return this.stopwords;
    }

    /**
     * Set the stopwords property: The list of stopwords. This property and the stopwords list property cannot both be
     * set.
     *
     * @param stopwords the stopwords value to set.
     * @return the StopwordsTokenFilter object itself.
     */
    @Generated
    public StopwordsTokenFilter setStopwords(List<String> stopwords) {
        this.stopwords = stopwords;
        return this;
    }

    /**
     * Get the stopwordsList property: A predefined list of stopwords to use. This property and the stopwords property
     * cannot both be set. Default is English.
     *
     * @return the stopwordsList value.
     */
    @Generated
    public StopwordsList getStopwordsList() {
        return this.stopwordsList;
    }

    /**
     * Set the stopwordsList property: A predefined list of stopwords to use. This property and the stopwords property
     * cannot both be set. Default is English.
     *
     * @param stopwordsList the stopwordsList value to set.
     * @return the StopwordsTokenFilter object itself.
     */
    @Generated
    public StopwordsTokenFilter setStopwordsList(StopwordsList stopwordsList) {
        this.stopwordsList = stopwordsList;
        return this;
    }

    /**
     * Get the caseIgnored property: A value indicating whether to ignore case. If true, all words are converted to
     * lower case first. Default is false.
     *
     * @return the caseIgnored value.
     */
    @Generated
    public Boolean isCaseIgnored() {
        return this.caseIgnored;
    }

    /**
     * Set the caseIgnored property: A value indicating whether to ignore case. If true, all words are converted to
     * lower case first. Default is false.
     *
     * @param caseIgnored the caseIgnored value to set.
     * @return the StopwordsTokenFilter object itself.
     */
    @Generated
    public StopwordsTokenFilter setCaseIgnored(Boolean caseIgnored) {
        this.caseIgnored = caseIgnored;
        return this;
    }

    /**
     * Get the trailingStopWordsRemoved property: A value indicating whether to ignore the last search term if it's a
     * stop word. Default is true.
     *
     * @return the trailingStopWordsRemoved value.
     */
    @Generated
    public Boolean areTrailingStopWordsRemoved() {
        return this.trailingStopWordsRemoved;
    }

    /**
     * Set the trailingStopWordsRemoved property: A value indicating whether to ignore the last search term if it's a
     * stop word. Default is true.
     *
     * @param trailingStopWordsRemoved the trailingStopWordsRemoved value to set.
     * @return the StopwordsTokenFilter object itself.
     */
    @Generated
    public StopwordsTokenFilter setTrailingStopWordsRemoved(Boolean trailingStopWordsRemoved) {
        this.trailingStopWordsRemoved = trailingStopWordsRemoved;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", getName());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeArrayField("stopwords", this.stopwords, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("stopwordsList", this.stopwordsList == null ? null : this.stopwordsList.toString());
        jsonWriter.writeBooleanField("ignoreCase", this.caseIgnored);
        jsonWriter.writeBooleanField("removeTrailing", this.trailingStopWordsRemoved);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StopwordsTokenFilter from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of StopwordsTokenFilter if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the StopwordsTokenFilter.
     */
    @Generated
    public static StopwordsTokenFilter fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String odataType = "#Microsoft.Azure.Search.StopwordsTokenFilter";
            List<String> stopwords = null;
            StopwordsList stopwordsList = null;
            Boolean caseIgnored = null;
            Boolean trailingStopWordsRemoved = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                } else if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                } else if ("stopwords".equals(fieldName)) {
                    stopwords = reader.readArray(reader1 -> reader1.getString());
                } else if ("stopwordsList".equals(fieldName)) {
                    stopwordsList = StopwordsList.fromString(reader.getString());
                } else if ("ignoreCase".equals(fieldName)) {
                    caseIgnored = reader.getNullable(JsonReader::getBoolean);
                } else if ("removeTrailing".equals(fieldName)) {
                    trailingStopWordsRemoved = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }
            if (nameFound) {
                StopwordsTokenFilter deserializedStopwordsTokenFilter = new StopwordsTokenFilter(name);
                deserializedStopwordsTokenFilter.odataType = odataType;
                deserializedStopwordsTokenFilter.stopwords = stopwords;
                deserializedStopwordsTokenFilter.stopwordsList = stopwordsList;
                deserializedStopwordsTokenFilter.caseIgnored = caseIgnored;
                deserializedStopwordsTokenFilter.trailingStopWordsRemoved = trailingStopWordsRemoved;
                return deserializedStopwordsTokenFilter;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }

    /**
     * Set the stopwords property: The list of stopwords. This property and the stopwords list property cannot both be
     * set.
     *
     * @param stopwords the stopwords value to set.
     * @return the StopwordsTokenFilter object itself.
     */
    public StopwordsTokenFilter setStopwords(String... stopwords) {
        this.stopwords = (stopwords == null) ? null : Arrays.asList(stopwords);
        return this;
    }
}
