// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Provides parameter values to a tag scoring function.
 */
@Immutable
public final class TagScoringParameters implements JsonSerializable<TagScoringParameters> {
    /*
     * The name of the parameter passed in search queries to specify the list of tags to compare against the target
     * field.
     */
    @Generated
    private final String tagsParameter;

    /**
     * Creates an instance of TagScoringParameters class.
     * 
     * @param tagsParameter the tagsParameter value to set.
     */
    @Generated
    public TagScoringParameters(String tagsParameter) {
        this.tagsParameter = tagsParameter;
    }

    /**
     * Get the tagsParameter property: The name of the parameter passed in search queries to specify the list of tags to
     * compare against the target field.
     * 
     * @return the tagsParameter value.
     */
    @Generated
    public String getTagsParameter() {
        return this.tagsParameter;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("tagsParameter", this.tagsParameter);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TagScoringParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TagScoringParameters if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the TagScoringParameters.
     */
    @Generated
    public static TagScoringParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean tagsParameterFound = false;
            String tagsParameter = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("tagsParameter".equals(fieldName)) {
                    tagsParameter = reader.getString();
                    tagsParameterFound = true;
                } else {
                    reader.skipChildren();
                }
            }
            if (tagsParameterFound) {
                return new TagScoringParameters(tagsParameter);
            }
            throw new IllegalStateException("Missing required property: tagsParameter");
        });
    }
}
