// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * Defines weights on index fields for which matches should boost scoring in search queries.
 */
@Immutable
public final class TextWeights implements JsonSerializable<TextWeights> {
    /*
     * The dictionary of per-field weights to boost document scoring. The keys are field names and the values are the
     * weights for each field.
     */
    @Generated
    private final Map<String, Double> weights;

    /**
     * Creates an instance of TextWeights class.
     * 
     * @param weights the weights value to set.
     */
    @Generated
    public TextWeights(Map<String, Double> weights) {
        this.weights = weights;
    }

    /**
     * Get the weights property: The dictionary of per-field weights to boost document scoring. The keys are field names
     * and the values are the weights for each field.
     * 
     * @return the weights value.
     */
    @Generated
    public Map<String, Double> getWeights() {
        return this.weights;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("weights", this.weights, (writer, element) -> writer.writeDouble(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TextWeights from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TextWeights if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the TextWeights.
     */
    @Generated
    public static TextWeights fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean weightsFound = false;
            Map<String, Double> weights = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("weights".equals(fieldName)) {
                    weights = reader.readMap(reader1 -> reader1.getDouble());
                    weightsFound = true;
                } else {
                    reader.skipChildren();
                }
            }
            if (weightsFound) {
                return new TextWeights(weights);
            }
            throw new IllegalStateException("Missing required property: weights");
        });
    }
}
