// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Allows you to generate a vector embedding for a given image or text input using the Azure AI Services Vision
 * Vectorize API.
 */
@Fluent
public final class VisionVectorizeSkill extends SearchIndexerSkill {
    /*
     * A URI fragment specifying the type of skill.
     */
    @Generated
    private String odataType = "#Microsoft.Skills.Vision.VectorizeSkill";

    /*
     * The version of the model to use when calling the AI Services Vision service. It will default to the latest
     * available when not specified.
     */
    @Generated
    private final String modelVersion;

    /**
     * Creates an instance of VisionVectorizeSkill class.
     * 
     * @param inputs the inputs value to set.
     * @param outputs the outputs value to set.
     * @param modelVersion the modelVersion value to set.
     */
    @Generated
    public VisionVectorizeSkill(List<InputFieldMappingEntry> inputs, List<OutputFieldMappingEntry> outputs,
        String modelVersion) {
        super(inputs, outputs);
        this.modelVersion = modelVersion;
    }

    /**
     * Get the odataType property: A URI fragment specifying the type of skill.
     * 
     * @return the odataType value.
     */
    @Generated
    @Override
    public String getOdataType() {
        return this.odataType;
    }

    /**
     * Get the modelVersion property: The version of the model to use when calling the AI Services Vision service. It
     * will default to the latest available when not specified.
     * 
     * @return the modelVersion value.
     */
    @Generated
    public String getModelVersion() {
        return this.modelVersion;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public VisionVectorizeSkill setName(String name) {
        super.setName(name);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public VisionVectorizeSkill setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public VisionVectorizeSkill setContext(String context) {
        super.setContext(context);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("inputs", getInputs(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("outputs", getOutputs(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("name", getName());
        jsonWriter.writeStringField("description", getDescription());
        jsonWriter.writeStringField("context", getContext());
        jsonWriter.writeStringField("modelVersion", this.modelVersion);
        jsonWriter.writeStringField("@odata.type", this.odataType);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VisionVectorizeSkill from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VisionVectorizeSkill if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the VisionVectorizeSkill.
     */
    @Generated
    public static VisionVectorizeSkill fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean inputsFound = false;
            List<InputFieldMappingEntry> inputs = null;
            boolean outputsFound = false;
            List<OutputFieldMappingEntry> outputs = null;
            String name = null;
            String description = null;
            String context = null;
            boolean modelVersionFound = false;
            String modelVersion = null;
            String odataType = "#Microsoft.Skills.Vision.VectorizeSkill";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("inputs".equals(fieldName)) {
                    inputs = reader.readArray(reader1 -> InputFieldMappingEntry.fromJson(reader1));
                    inputsFound = true;
                } else if ("outputs".equals(fieldName)) {
                    outputs = reader.readArray(reader1 -> OutputFieldMappingEntry.fromJson(reader1));
                    outputsFound = true;
                } else if ("name".equals(fieldName)) {
                    name = reader.getString();
                } else if ("description".equals(fieldName)) {
                    description = reader.getString();
                } else if ("context".equals(fieldName)) {
                    context = reader.getString();
                } else if ("modelVersion".equals(fieldName)) {
                    modelVersion = reader.getString();
                    modelVersionFound = true;
                } else if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            if (inputsFound && outputsFound && modelVersionFound) {
                VisionVectorizeSkill deserializedVisionVectorizeSkill
                    = new VisionVectorizeSkill(inputs, outputs, modelVersion);
                deserializedVisionVectorizeSkill.setName(name);
                deserializedVisionVectorizeSkill.setDescription(description);
                deserializedVisionVectorizeSkill.setContext(context);
                deserializedVisionVectorizeSkill.odataType = odataType;

                return deserializedVisionVectorizeSkill;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!inputsFound) {
                missingProperties.add("inputs");
            }
            if (!outputsFound) {
                missingProperties.add("outputs");
            }
            if (!modelVersionFound) {
                missingProperties.add("modelVersion");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
