// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;
import java.util.Map;

/**
 * Specifies the properties for connecting to a user-defined vectorizer.
 */
@Fluent
public final class WebApiVectorizerParameters implements JsonSerializable<WebApiVectorizerParameters> {
    /*
     * The URI of the Web API providing the vectorizer.
     */
    @Generated
    private String url;

    /*
     * The headers required to make the HTTP request.
     */
    @Generated
    private Map<String, String> httpHeaders;

    /*
     * The method for the HTTP request.
     */
    @Generated
    private String httpMethod;

    /*
     * The desired timeout for the request. Default is 30 seconds.
     */
    @Generated
    private Duration timeout;

    /*
     * Applies to custom endpoints that connect to external code in an Azure function or some other application that
     * provides the transformations. This value should be the application ID created for the function or app when it was
     * registered with Azure Active Directory. When specified, the vectorization connects to the function or app using a
     * managed ID (either system or user-assigned) of the search service and the access token of the function or app,
     * using this value as the resource id for creating the scope of the access token.
     */
    @Generated
    private String authResourceId;

    /*
     * The user-assigned managed identity used for outbound connections. If an authResourceId is provided and it's not
     * specified, the system-assigned managed identity is used. On updates to the indexer, if the identity is
     * unspecified, the value remains unchanged. If set to "none", the value of this property is cleared.
     */
    @Generated
    private SearchIndexerDataIdentity authIdentity;

    /**
     * Creates an instance of WebApiVectorizerParameters class.
     */
    @Generated
    public WebApiVectorizerParameters() {
    }

    /**
     * Get the url property: The URI of the Web API providing the vectorizer.
     * 
     * @return the url value.
     */
    @Generated
    public String getUrl() {
        return this.url;
    }

    /**
     * Set the url property: The URI of the Web API providing the vectorizer.
     * 
     * @param url the url value to set.
     * @return the WebApiVectorizerParameters object itself.
     */
    @Generated
    public WebApiVectorizerParameters setUrl(String url) {
        this.url = url;
        return this;
    }

    /**
     * Get the httpHeaders property: The headers required to make the HTTP request.
     * 
     * @return the httpHeaders value.
     */
    @Generated
    public Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    /**
     * Set the httpHeaders property: The headers required to make the HTTP request.
     * 
     * @param httpHeaders the httpHeaders value to set.
     * @return the WebApiVectorizerParameters object itself.
     */
    @Generated
    public WebApiVectorizerParameters setHttpHeaders(Map<String, String> httpHeaders) {
        this.httpHeaders = httpHeaders;
        return this;
    }

    /**
     * Get the httpMethod property: The method for the HTTP request.
     * 
     * @return the httpMethod value.
     */
    @Generated
    public String getHttpMethod() {
        return this.httpMethod;
    }

    /**
     * Set the httpMethod property: The method for the HTTP request.
     * 
     * @param httpMethod the httpMethod value to set.
     * @return the WebApiVectorizerParameters object itself.
     */
    @Generated
    public WebApiVectorizerParameters setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    /**
     * Get the timeout property: The desired timeout for the request. Default is 30 seconds.
     * 
     * @return the timeout value.
     */
    @Generated
    public Duration getTimeout() {
        return this.timeout;
    }

    /**
     * Set the timeout property: The desired timeout for the request. Default is 30 seconds.
     * 
     * @param timeout the timeout value to set.
     * @return the WebApiVectorizerParameters object itself.
     */
    @Generated
    public WebApiVectorizerParameters setTimeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    /**
     * Get the authResourceId property: Applies to custom endpoints that connect to external code in an Azure function
     * or some other application that provides the transformations. This value should be the application ID created for
     * the function or app when it was registered with Azure Active Directory. When specified, the vectorization
     * connects to the function or app using a managed ID (either system or user-assigned) of the search service and the
     * access token of the function or app, using this value as the resource id for creating the scope of the access
     * token.
     * 
     * @return the authResourceId value.
     */
    @Generated
    public String getAuthResourceId() {
        return this.authResourceId;
    }

    /**
     * Set the authResourceId property: Applies to custom endpoints that connect to external code in an Azure function
     * or some other application that provides the transformations. This value should be the application ID created for
     * the function or app when it was registered with Azure Active Directory. When specified, the vectorization
     * connects to the function or app using a managed ID (either system or user-assigned) of the search service and the
     * access token of the function or app, using this value as the resource id for creating the scope of the access
     * token.
     * 
     * @param authResourceId the authResourceId value to set.
     * @return the WebApiVectorizerParameters object itself.
     */
    @Generated
    public WebApiVectorizerParameters setAuthResourceId(String authResourceId) {
        this.authResourceId = authResourceId;
        return this;
    }

    /**
     * Get the authIdentity property: The user-assigned managed identity used for outbound connections. If an
     * authResourceId is provided and it's not specified, the system-assigned managed identity is used. On updates to
     * the indexer, if the identity is unspecified, the value remains unchanged. If set to "none", the value of this
     * property is cleared.
     * 
     * @return the authIdentity value.
     */
    @Generated
    public SearchIndexerDataIdentity getAuthIdentity() {
        return this.authIdentity;
    }

    /**
     * Set the authIdentity property: The user-assigned managed identity used for outbound connections. If an
     * authResourceId is provided and it's not specified, the system-assigned managed identity is used. On updates to
     * the indexer, if the identity is unspecified, the value remains unchanged. If set to "none", the value of this
     * property is cleared.
     * 
     * @param authIdentity the authIdentity value to set.
     * @return the WebApiVectorizerParameters object itself.
     */
    @Generated
    public WebApiVectorizerParameters setAuthIdentity(SearchIndexerDataIdentity authIdentity) {
        this.authIdentity = authIdentity;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("uri", this.url);
        jsonWriter.writeMapField("httpHeaders", this.httpHeaders, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("httpMethod", this.httpMethod);
        jsonWriter.writeStringField("timeout", CoreUtils.durationToStringWithDays(this.timeout));
        jsonWriter.writeStringField("authResourceId", this.authResourceId);
        jsonWriter.writeJsonField("authIdentity", this.authIdentity);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WebApiVectorizerParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WebApiVectorizerParameters if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the WebApiVectorizerParameters.
     */
    @Generated
    public static WebApiVectorizerParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WebApiVectorizerParameters deserializedWebApiVectorizerParameters = new WebApiVectorizerParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("uri".equals(fieldName)) {
                    deserializedWebApiVectorizerParameters.url = reader.getString();
                } else if ("httpHeaders".equals(fieldName)) {
                    Map<String, String> httpHeaders = reader.readMap(reader1 -> reader1.getString());
                    deserializedWebApiVectorizerParameters.httpHeaders = httpHeaders;
                } else if ("httpMethod".equals(fieldName)) {
                    deserializedWebApiVectorizerParameters.httpMethod = reader.getString();
                } else if ("timeout".equals(fieldName)) {
                    deserializedWebApiVectorizerParameters.timeout
                        = reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                } else if ("authResourceId".equals(fieldName)) {
                    deserializedWebApiVectorizerParameters.authResourceId = reader.getString();
                } else if ("authIdentity".equals(fieldName)) {
                    deserializedWebApiVectorizerParameters.authIdentity = SearchIndexerDataIdentity.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWebApiVectorizerParameters;
        });
    }
}
