// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Contains debugging information that can be used to further explore your search results.
 */
@Immutable
public final class DocumentDebugInfo implements JsonSerializable<DocumentDebugInfo> {
    /*
     * Contains debugging information specific to semantic ranking requests.
     */
    @Generated
    private SemanticDebugInfo semantic;

    /*
     * Contains debugging information specific to vector and hybrid search.
     */
    @Generated
    private VectorsDebugInfo vectors;

    /*
     * Contains debugging information specific to vectors matched within a collection of complex types.
     */
    @Generated
    private Map<String, List<QueryResultDocumentInnerHit>> innerHits;

    /**
     * Creates an instance of DocumentDebugInfo class.
     */
    @Generated
    public DocumentDebugInfo() {
    }

    /**
     * Get the semantic property: Contains debugging information specific to semantic ranking requests.
     * 
     * @return the semantic value.
     */
    @Generated
    public SemanticDebugInfo getSemantic() {
        return this.semantic;
    }

    /**
     * Get the vectors property: Contains debugging information specific to vector and hybrid search.
     * 
     * @return the vectors value.
     */
    @Generated
    public VectorsDebugInfo getVectors() {
        return this.vectors;
    }

    /**
     * Get the innerHits property: Contains debugging information specific to vectors matched within a collection of
     * complex types.
     * 
     * @return the innerHits value.
     */
    @Generated
    public Map<String, List<QueryResultDocumentInnerHit>> getInnerHits() {
        return this.innerHits;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DocumentDebugInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DocumentDebugInfo if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the DocumentDebugInfo.
     */
    @Generated
    public static DocumentDebugInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DocumentDebugInfo deserializedDocumentDebugInfo = new DocumentDebugInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("semantic".equals(fieldName)) {
                    deserializedDocumentDebugInfo.semantic = SemanticDebugInfo.fromJson(reader);
                } else if ("vectors".equals(fieldName)) {
                    deserializedDocumentDebugInfo.vectors = VectorsDebugInfo.fromJson(reader);
                } else if ("innerHits".equals(fieldName)) {
                    Map<String, List<QueryResultDocumentInnerHit>> innerHits = reader.readMap(
                        reader1 -> reader1.readArray(reader2 -> QueryResultDocumentInnerHit.fromJson(reader2)));
                    deserializedDocumentDebugInfo.innerHits = innerHits;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDocumentDebugInfo;
        });
    }
}
