// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * A single bucket of a facet query result. Reports the number of documents with a field value falling within a
 * particular range or having a particular value or interval.
 */
@Fluent
public final class FacetResult implements JsonSerializable<FacetResult> {
    /*
     * The approximate count of documents falling within the bucket described by this facet.
     */
    @Generated
    private Long count;

    /*
     * The resulting total sum for the facet when a sum metric is requested.
     */
    @Generated
    private Double sum;

    /*
     * The nested facet query results for the search operation, organized as a collection of buckets for each faceted
     * field; null if the query did not contain any nested facets.
     */
    @Generated
    private Map<String, List<FacetResult>> facets;

    /*
     * A single bucket of a facet query result. Reports the number of documents with a field value falling within a
     * particular range or having a particular value or interval.
     */
    @Generated
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of FacetResult class.
     */
    @Generated
    public FacetResult() {
    }

    /**
     * Get the count property: The approximate count of documents falling within the bucket described by this facet.
     * 
     * @return the count value.
     */
    @Generated
    public Long getCount() {
        return this.count;
    }

    /**
     * Get the sum property: The resulting total sum for the facet when a sum metric is requested.
     * 
     * @return the sum value.
     */
    @Generated
    public Double getSum() {
        return this.sum;
    }

    /**
     * Get the facets property: The nested facet query results for the search operation, organized as a collection of
     * buckets for each faceted field; null if the query did not contain any nested facets.
     * 
     * @return the facets value.
     */
    @Generated
    public Map<String, List<FacetResult>> getFacets() {
        return this.facets;
    }

    /**
     * Get the additionalProperties property: A single bucket of a facet query result. Reports the number of documents
     * with a field value falling within a particular range or having a particular value or interval.
     * 
     * @return the additionalProperties value.
     */
    @Generated
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: A single bucket of a facet query result. Reports the number of documents
     * with a field value falling within a particular range or having a particular value or interval.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the FacetResult object itself.
     */
    @Generated
    public FacetResult setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FacetResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FacetResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the FacetResult.
     */
    @Generated
    public static FacetResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FacetResult deserializedFacetResult = new FacetResult();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("count".equals(fieldName)) {
                    deserializedFacetResult.count = reader.getNullable(JsonReader::getLong);
                } else if ("sum".equals(fieldName)) {
                    deserializedFacetResult.sum = reader.getNullable(JsonReader::getDouble);
                } else if ("@search.facets".equals(fieldName)) {
                    Map<String, List<FacetResult>> facets
                        = reader.readMap(reader1 -> reader1.readArray(reader2 -> FacetResult.fromJson(reader2)));
                    deserializedFacetResult.facets = facets;
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedFacetResult.additionalProperties = additionalProperties;

            return deserializedFacetResult;
        });
    }
}
