// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Determines whether the count and facets should includes all documents that matched the search query, or only the
 * documents that are retrieved within the 'maxTextRecallSize' window. The default value is 'countAllResults'.
 */
public final class HybridCountAndFacetMode extends ExpandableStringEnum<HybridCountAndFacetMode> {
    /**
     * Only include documents that were matched within the 'maxTextRecallSize' retrieval window when computing 'count'
     * and 'facets'.
     */
    @Generated
    public static final HybridCountAndFacetMode COUNT_RETRIEVABLE_RESULTS = fromString("countRetrievableResults");

    /**
     * Include all documents that were matched by the search query when computing 'count' and 'facets', regardless of
     * whether or not those documents are within the 'maxTextRecallSize' retrieval window.
     */
    @Generated
    public static final HybridCountAndFacetMode COUNT_ALL_RESULTS = fromString("countAllResults");

    /**
     * Creates a new instance of HybridCountAndFacetMode value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public HybridCountAndFacetMode() {
    }

    /**
     * Creates or finds a HybridCountAndFacetMode from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding HybridCountAndFacetMode.
     */
    @Generated
    public static HybridCountAndFacetMode fromString(String name) {
        return fromString(name, HybridCountAndFacetMode.class);
    }

    /**
     * Gets known HybridCountAndFacetMode values.
     * 
     * @return known HybridCountAndFacetMode values.
     */
    @Generated
    public static Collection<HybridCountAndFacetMode> values() {
        return values(HybridCountAndFacetMode.class);
    }
}
