// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * TThe query parameters to configure hybrid search behaviors.
 */
@Fluent
public final class HybridSearch implements JsonSerializable<HybridSearch> {
    /*
     * Determines the maximum number of documents to be retrieved by the text query portion of a hybrid search request.
     * Those documents will be combined with the documents matching the vector queries to produce a single final list of
     * results. Choosing a larger maxTextRecallSize value will allow retrieving and paging through more documents (using
     * the top and skip parameters), at the cost of higher resource utilization and higher latency. The value needs to
     * be between 1 and 10,000. Default is 1000.
     */
    @Generated
    private Integer maxTextRecallSize;

    /*
     * Determines whether the count and facets should includes all documents that matched the search query, or only the
     * documents that are retrieved within the 'maxTextRecallSize' window.
     */
    @Generated
    private HybridCountAndFacetMode countAndFacetMode;

    /**
     * Creates an instance of HybridSearch class.
     */
    @Generated
    public HybridSearch() {
    }

    /**
     * Get the maxTextRecallSize property: Determines the maximum number of documents to be retrieved by the text query
     * portion of a hybrid search request. Those documents will be combined with the documents matching the vector
     * queries to produce a single final list of results. Choosing a larger maxTextRecallSize value will allow
     * retrieving and paging through more documents (using the top and skip parameters), at the cost of higher resource
     * utilization and higher latency. The value needs to be between 1 and 10,000. Default is 1000.
     * 
     * @return the maxTextRecallSize value.
     */
    @Generated
    public Integer getMaxTextRecallSize() {
        return this.maxTextRecallSize;
    }

    /**
     * Set the maxTextRecallSize property: Determines the maximum number of documents to be retrieved by the text query
     * portion of a hybrid search request. Those documents will be combined with the documents matching the vector
     * queries to produce a single final list of results. Choosing a larger maxTextRecallSize value will allow
     * retrieving and paging through more documents (using the top and skip parameters), at the cost of higher resource
     * utilization and higher latency. The value needs to be between 1 and 10,000. Default is 1000.
     * 
     * @param maxTextRecallSize the maxTextRecallSize value to set.
     * @return the HybridSearch object itself.
     */
    @Generated
    public HybridSearch setMaxTextRecallSize(Integer maxTextRecallSize) {
        this.maxTextRecallSize = maxTextRecallSize;
        return this;
    }

    /**
     * Get the countAndFacetMode property: Determines whether the count and facets should includes all documents that
     * matched the search query, or only the documents that are retrieved within the 'maxTextRecallSize' window.
     * 
     * @return the countAndFacetMode value.
     */
    @Generated
    public HybridCountAndFacetMode getCountAndFacetMode() {
        return this.countAndFacetMode;
    }

    /**
     * Set the countAndFacetMode property: Determines whether the count and facets should includes all documents that
     * matched the search query, or only the documents that are retrieved within the 'maxTextRecallSize' window.
     * 
     * @param countAndFacetMode the countAndFacetMode value to set.
     * @return the HybridSearch object itself.
     */
    @Generated
    public HybridSearch setCountAndFacetMode(HybridCountAndFacetMode countAndFacetMode) {
        this.countAndFacetMode = countAndFacetMode;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("maxTextRecallSize", this.maxTextRecallSize);
        jsonWriter.writeStringField("countAndFacetMode",
            this.countAndFacetMode == null ? null : this.countAndFacetMode.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of HybridSearch from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of HybridSearch if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the HybridSearch.
     */
    @Generated
    public static HybridSearch fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            HybridSearch deserializedHybridSearch = new HybridSearch();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("maxTextRecallSize".equals(fieldName)) {
                    deserializedHybridSearch.maxTextRecallSize = reader.getNullable(JsonReader::getInt);
                } else if ("countAndFacetMode".equals(fieldName)) {
                    deserializedHybridSearch.countAndFacetMode = HybridCountAndFacetMode.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedHybridSearch;
        });
    }
}
