// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Description of fields that were sent to the semantic enrichment process, as well as how they were used.
 */
@Immutable
public final class QueryResultDocumentSemanticField implements JsonSerializable<QueryResultDocumentSemanticField> {
    /*
     * The name of the field that was sent to the semantic enrichment process
     */
    @Generated
    private String name;

    /*
     * The way the field was used for the semantic enrichment process (fully used, partially used, or unused)
     */
    @Generated
    private SemanticFieldState state;

    /**
     * Creates an instance of QueryResultDocumentSemanticField class.
     */
    @Generated
    public QueryResultDocumentSemanticField() {
    }

    /**
     * Get the name property: The name of the field that was sent to the semantic enrichment process.
     * 
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * Get the state property: The way the field was used for the semantic enrichment process (fully used, partially
     * used, or unused).
     * 
     * @return the state value.
     */
    @Generated
    public SemanticFieldState getState() {
        return this.state;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of QueryResultDocumentSemanticField from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of QueryResultDocumentSemanticField if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the QueryResultDocumentSemanticField.
     */
    @Generated
    public static QueryResultDocumentSemanticField fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            QueryResultDocumentSemanticField deserializedQueryResultDocumentSemanticField
                = new QueryResultDocumentSemanticField();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedQueryResultDocumentSemanticField.name = reader.getString();
                } else if ("state".equals(fieldName)) {
                    deserializedQueryResultDocumentSemanticField.state
                        = SemanticFieldState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedQueryResultDocumentSemanticField;
        });
    }
}
