// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The kind of vector query being performed.
 */
public final class VectorThresholdKind extends ExpandableStringEnum<VectorThresholdKind> {
    /**
     * The results of the vector query will be filtered based on the vector similarity metric. Note this is the
     * canonical definition of similarity metric, not the 'distance' version. The threshold direction (larger or
     * smaller) will be chosen automatically according to the metric used by the field.
     */
    @Generated
    public static final VectorThresholdKind VECTOR_SIMILARITY = fromString("vectorSimilarity");

    /**
     * The results of the vector query will filter based on the '&#064;search.score' value. Note this is the
     * &#064;search.score returned as part of the search response. The threshold direction will be chosen for higher
     * &#064;search.score.
     */
    @Generated
    public static final VectorThresholdKind SEARCH_SCORE = fromString("searchScore");

    /**
     * Creates a new instance of VectorThresholdKind value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public VectorThresholdKind() {
    }

    /**
     * Creates or finds a VectorThresholdKind from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding VectorThresholdKind.
     */
    @Generated
    public static VectorThresholdKind fromString(String name) {
        return fromString(name, VectorThresholdKind.class);
    }

    /**
     * Gets known VectorThresholdKind values.
     * 
     * @return known VectorThresholdKind values.
     */
    @Generated
    public static Collection<VectorThresholdKind> values() {
        return values(VectorThresholdKind.class);
    }
}
