// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
package com.azure.search.documents.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The query parameters to use for vector search when a base 64 encoded binary of an image that needs to be vectorized
 * is provided.
 */
@Fluent
public final class VectorizableImageBinaryQuery extends VectorQuery {

    /*
     * The kind of vector query being performed.
     */
    @Generated
    private VectorQueryKind kind = VectorQueryKind.IMAGE_BINARY;

    /*
     * The base 64 encoded binary of an image to be vectorized to perform a vector search query.
     */
    @Generated
    private String base64Image;

    /**
     * Creates an instance of VectorizableImageBinaryQuery class.
     */
    @Generated
    public VectorizableImageBinaryQuery() {
    }

    /**
     * Get the kind property: The kind of vector query being performed.
     *
     * @return the kind value.
     */
    @Generated
    @Override
    public VectorQueryKind getKind() {
        return this.kind;
    }

    /**
     * Get the base64Image property: The base 64 encoded binary of an image to be vectorized to perform a vector search
     * query.
     *
     * @return the base64Image value.
     */
    @Generated
    public String getBase64Image() {
        return this.base64Image;
    }

    /**
     * Set the base64Image property: The base 64 encoded binary of an image to be vectorized to perform a vector search
     * query.
     *
     * @param base64Image the base64Image value to set.
     * @return the VectorizableImageBinaryQuery object itself.
     */
    @Generated
    public VectorizableImageBinaryQuery setBase64Image(String base64Image) {
        this.base64Image = base64Image;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public VectorizableImageBinaryQuery setKNearestNeighborsCount(Integer kNearestNeighborsCount) {
        super.setKNearestNeighborsCount(kNearestNeighborsCount);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public VectorizableImageBinaryQuery setFields(String... fields) {
        super.setFields(fields);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public VectorizableImageBinaryQuery setExhaustive(Boolean exhaustive) {
        super.setExhaustive(exhaustive);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public VectorizableImageBinaryQuery setOversampling(Double oversampling) {
        super.setOversampling(oversampling);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public VectorizableImageBinaryQuery setWeight(Float weight) {
        super.setWeight(weight);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public VectorizableImageBinaryQuery setThreshold(VectorThreshold threshold) {
        super.setThreshold(threshold);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public VectorizableImageBinaryQuery setFilterOverride(String filterOverride) {
        super.setFilterOverride(filterOverride);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public VectorizableImageBinaryQuery setPerDocumentVectorLimit(Integer perDocumentVectorLimit) {
        super.setPerDocumentVectorLimit(perDocumentVectorLimit);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("k", getKNearestNeighborsCount());
        jsonWriter.writeStringField("fields", getFields());
        jsonWriter.writeBooleanField("exhaustive", isExhaustive());
        jsonWriter.writeNumberField("oversampling", getOversampling());
        jsonWriter.writeNumberField("weight", getWeight());
        jsonWriter.writeJsonField("threshold", getThreshold());
        jsonWriter.writeStringField("filterOverride", getFilterOverride());
        jsonWriter.writeNumberField("perDocumentVectorLimit", getPerDocumentVectorLimit());
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeStringField("base64Image", this.base64Image);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VectorizableImageBinaryQuery from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of VectorizableImageBinaryQuery if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VectorizableImageBinaryQuery.
     */
    @Generated
    public static VectorizableImageBinaryQuery fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VectorizableImageBinaryQuery deserializedVectorizableImageBinaryQuery = new VectorizableImageBinaryQuery();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("k".equals(fieldName)) {
                    deserializedVectorizableImageBinaryQuery
                        .setKNearestNeighborsCount(reader.getNullable(JsonReader::getInt));
                } else if ("fields".equals(fieldName)) {
                    deserializedVectorizableImageBinaryQuery.setFields(reader.getString());
                } else if ("exhaustive".equals(fieldName)) {
                    deserializedVectorizableImageBinaryQuery.setExhaustive(reader.getNullable(JsonReader::getBoolean));
                } else if ("oversampling".equals(fieldName)) {
                    deserializedVectorizableImageBinaryQuery.setOversampling(reader.getNullable(JsonReader::getDouble));
                } else if ("weight".equals(fieldName)) {
                    deserializedVectorizableImageBinaryQuery.setWeight(reader.getNullable(JsonReader::getFloat));
                } else if ("threshold".equals(fieldName)) {
                    deserializedVectorizableImageBinaryQuery.setThreshold(VectorThreshold.fromJson(reader));
                } else if ("filterOverride".equals(fieldName)) {
                    deserializedVectorizableImageBinaryQuery.setFilterOverride(reader.getString());
                } else if ("perDocumentVectorLimit".equals(fieldName)) {
                    deserializedVectorizableImageBinaryQuery
                        .setPerDocumentVectorLimit(reader.getNullable(JsonReader::getInt));
                } else if ("kind".equals(fieldName)) {
                    deserializedVectorizableImageBinaryQuery.kind = VectorQueryKind.fromString(reader.getString());
                } else if ("base64Image".equals(fieldName)) {
                    deserializedVectorizableImageBinaryQuery.base64Image = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedVectorizableImageBinaryQuery;
        });
    }
}
