// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The VectorsDebugInfo model.
 */
@Immutable
public final class VectorsDebugInfo implements JsonSerializable<VectorsDebugInfo> {
    /*
     * The breakdown of subscores of the document prior to the chosen result set fusion/combination method such as RRF.
     */
    @Generated
    private QueryResultDocumentSubscores subscores;

    /**
     * Creates an instance of VectorsDebugInfo class.
     */
    @Generated
    public VectorsDebugInfo() {
    }

    /**
     * Get the subscores property: The breakdown of subscores of the document prior to the chosen result set
     * fusion/combination method such as RRF.
     * 
     * @return the subscores value.
     */
    @Generated
    public QueryResultDocumentSubscores getSubscores() {
        return this.subscores;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VectorsDebugInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VectorsDebugInfo if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the VectorsDebugInfo.
     */
    @Generated
    public static VectorsDebugInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VectorsDebugInfo deserializedVectorsDebugInfo = new VectorsDebugInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("subscores".equals(fieldName)) {
                    deserializedVectorsDebugInfo.subscores = QueryResultDocumentSubscores.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVectorsDebugInfo;
        });
    }
}
