/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.ServiceVersion;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JsonSerializer;
import com.azure.core.util.serializer.ObjectSerializer;
import com.azure.core.util.serializer.TypeReference;
import com.azure.search.documents.SearchClientBuilder;
import com.azure.search.documents.SearchServiceVersion;
import com.azure.search.documents.implementation.SearchIndexClientImpl;
import com.azure.search.documents.implementation.converters.IndexActionConverter;
import com.azure.search.documents.implementation.converters.SearchResultConverter;
import com.azure.search.documents.implementation.converters.SuggestResultConverter;
import com.azure.search.documents.implementation.models.AutocompleteRequest;
import com.azure.search.documents.implementation.models.IndexAction;
import com.azure.search.documents.implementation.models.SearchContinuationToken;
import com.azure.search.documents.implementation.models.SearchDocumentsResult;
import com.azure.search.documents.implementation.models.SearchFirstPageResponseWrapper;
import com.azure.search.documents.implementation.models.SearchRequest;
import com.azure.search.documents.implementation.models.SuggestDocumentsResult;
import com.azure.search.documents.implementation.models.SuggestRequest;
import com.azure.search.documents.implementation.util.MappingUtils;
import com.azure.search.documents.implementation.util.Utility;
import com.azure.search.documents.indexes.models.IndexDocumentsBatch;
import com.azure.search.documents.models.AutocompleteOptions;
import com.azure.search.documents.models.AutocompleteResult;
import com.azure.search.documents.models.IndexActionType;
import com.azure.search.documents.models.IndexDocumentsOptions;
import com.azure.search.documents.models.IndexDocumentsResult;
import com.azure.search.documents.models.QueryAnswer;
import com.azure.search.documents.models.QueryAnswerType;
import com.azure.search.documents.models.QueryCaption;
import com.azure.search.documents.models.QueryCaptionType;
import com.azure.search.documents.models.QueryRewrites;
import com.azure.search.documents.models.ScoringParameter;
import com.azure.search.documents.models.SearchOptions;
import com.azure.search.documents.models.SearchResult;
import com.azure.search.documents.models.SemanticSearchOptions;
import com.azure.search.documents.models.SuggestOptions;
import com.azure.search.documents.models.SuggestResult;
import com.azure.search.documents.models.VectorSearchOptions;
import com.azure.search.documents.util.AutocompletePagedFlux;
import com.azure.search.documents.util.AutocompletePagedResponse;
import com.azure.search.documents.util.SearchPagedFlux;
import com.azure.search.documents.util.SearchPagedResponse;
import com.azure.search.documents.util.SuggestPagedFlux;
import com.azure.search.documents.util.SuggestPagedResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

@ServiceClient(builder=SearchClientBuilder.class, isAsync=true)
public final class SearchAsyncClient {
    private static final ClientLogger LOGGER = new ClientLogger(SearchAsyncClient.class);
    private final SearchServiceVersion serviceVersion;
    private final String endpoint;
    private final String indexName;
    private final SearchIndexClientImpl restClient;
    private final HttpPipeline httpPipeline;
    final JsonSerializer serializer;

    SearchAsyncClient(String endpoint, String indexName, SearchServiceVersion serviceVersion, HttpPipeline httpPipeline, JsonSerializer serializer, SearchIndexClientImpl restClient) {
        this.endpoint = endpoint;
        this.indexName = indexName;
        this.serviceVersion = serviceVersion;
        this.httpPipeline = httpPipeline;
        this.serializer = serializer;
        this.restClient = restClient;
    }

    public String getIndexName() {
        return this.indexName;
    }

    HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<IndexDocumentsResult> uploadDocuments(Iterable<?> documents) {
        return this.uploadDocumentsWithResponse(documents, null).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<IndexDocumentsResult>> uploadDocumentsWithResponse(Iterable<?> documents, IndexDocumentsOptions options) {
        return FluxUtil.withContext(context -> this.uploadDocumentsWithResponse(documents, options, (Context)context));
    }

    Mono<Response<IndexDocumentsResult>> uploadDocumentsWithResponse(Iterable<?> documents, IndexDocumentsOptions options, Context context) {
        return this.indexDocumentsWithResponse(SearchAsyncClient.buildIndexBatch(documents, IndexActionType.UPLOAD), options, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<IndexDocumentsResult> mergeDocuments(Iterable<?> documents) {
        return this.mergeDocumentsWithResponse(documents, null).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<IndexDocumentsResult>> mergeDocumentsWithResponse(Iterable<?> documents, IndexDocumentsOptions options) {
        return FluxUtil.withContext(context -> this.mergeDocumentsWithResponse(documents, options, (Context)context));
    }

    Mono<Response<IndexDocumentsResult>> mergeDocumentsWithResponse(Iterable<?> documents, IndexDocumentsOptions options, Context context) {
        return this.indexDocumentsWithResponse(SearchAsyncClient.buildIndexBatch(documents, IndexActionType.MERGE), options, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<IndexDocumentsResult> mergeOrUploadDocuments(Iterable<?> documents) {
        return this.mergeOrUploadDocumentsWithResponse(documents, null).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<IndexDocumentsResult>> mergeOrUploadDocumentsWithResponse(Iterable<?> documents, IndexDocumentsOptions options) {
        return FluxUtil.withContext(context -> this.mergeOrUploadDocumentsWithResponse(documents, options, (Context)context));
    }

    Mono<Response<IndexDocumentsResult>> mergeOrUploadDocumentsWithResponse(Iterable<?> documents, IndexDocumentsOptions options, Context context) {
        return this.indexDocumentsWithResponse(SearchAsyncClient.buildIndexBatch(documents, IndexActionType.MERGE_OR_UPLOAD), options, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<IndexDocumentsResult> deleteDocuments(Iterable<?> documents) {
        return this.deleteDocumentsWithResponse(documents, null).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<IndexDocumentsResult>> deleteDocumentsWithResponse(Iterable<?> documents, IndexDocumentsOptions options) {
        return FluxUtil.withContext(context -> this.deleteDocumentsWithResponse(documents, options, (Context)context));
    }

    Mono<Response<IndexDocumentsResult>> deleteDocumentsWithResponse(Iterable<?> documents, IndexDocumentsOptions options, Context context) {
        return this.indexDocumentsWithResponse(SearchAsyncClient.buildIndexBatch(documents, IndexActionType.DELETE), options, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<IndexDocumentsResult> indexDocuments(IndexDocumentsBatch<?> batch) {
        return this.indexDocumentsWithResponse(batch, null).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<IndexDocumentsResult>> indexDocumentsWithResponse(IndexDocumentsBatch<?> batch, IndexDocumentsOptions options) {
        return FluxUtil.withContext(context -> this.indexDocumentsWithResponse(batch, options, (Context)context));
    }

    Mono<Response<IndexDocumentsResult>> indexDocumentsWithResponse(IndexDocumentsBatch<?> batch, IndexDocumentsOptions options, Context context) {
        List<IndexAction> indexActions = batch.getActions().stream().map(document -> IndexActionConverter.map(document, (ObjectSerializer)this.serializer)).collect(Collectors.toList());
        boolean throwOnAnyError = options == null || options.throwOnAnyError();
        return Utility.indexDocumentsWithResponseAsync(this.restClient, indexActions, throwOnAnyError, context, LOGGER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public <T> Mono<T> getDocument(String key, Class<T> modelClass) {
        return this.getDocumentWithResponse(key, modelClass, null, null).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public <T> Mono<T> getDocument(String key, Class<T> modelClass, String querySourceAuthorization) {
        return this.getDocumentWithResponse(key, modelClass, null, querySourceAuthorization).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public <T> Mono<Response<T>> getDocumentWithResponse(String key, Class<T> modelClass, List<String> selectedFields) {
        return FluxUtil.withContext(context -> this.getDocumentWithResponse(key, modelClass, selectedFields, null, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public <T> Mono<Response<T>> getDocumentWithResponse(String key, Class<T> modelClass, List<String> selectedFields, String querySourceAuthorization) {
        return FluxUtil.withContext(context -> this.getDocumentWithResponse(key, modelClass, selectedFields, querySourceAuthorization, (Context)context));
    }

    <T> Mono<Response<T>> getDocumentWithResponse(String key, Class<T> modelClass, List<String> selectedFields, String querySourceAuthorization, Context context) {
        try {
            return this.restClient.getDocuments().getWithResponseAsync(key, selectedFields, querySourceAuthorization, null, context).onErrorMap(Utility::exceptionMapper).map(res -> new SimpleResponse(res, this.serializer.deserializeFromBytes(this.serializer.serializeToBytes(res.getValue()), TypeReference.createInstance((Class)modelClass))));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Long> getDocumentCount() {
        return this.getDocumentCountWithResponse().map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Long>> getDocumentCountWithResponse() {
        return FluxUtil.withContext(this::getDocumentCountWithResponse);
    }

    Mono<Response<Long>> getDocumentCountWithResponse(Context context) {
        try {
            return this.restClient.getDocuments().countWithResponseAsync(null, context).onErrorMap(MappingUtils::exceptionMapper).map(Function.identity());
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SearchPagedFlux search(String searchText) {
        return this.search(searchText, null, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SearchPagedFlux search(String searchText, String querySourceAuthorization) {
        return this.search(searchText, null, querySourceAuthorization, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SearchPagedFlux search(String searchText, SearchOptions searchOptions) {
        return this.search(searchText, searchOptions, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SearchPagedFlux search(String searchText, SearchOptions searchOptions, String querySourceAuthorization) {
        SearchRequest request = SearchAsyncClient.createSearchRequest(searchText, searchOptions);
        SearchFirstPageResponseWrapper firstPageResponse = new SearchFirstPageResponseWrapper();
        Function<String, Mono<SearchPagedResponse>> func = continuationToken -> FluxUtil.withContext(context -> this.search(request, (String)continuationToken, firstPageResponse, querySourceAuthorization, (Context)context));
        return new SearchPagedFlux(() -> (Mono)func.apply(null), func);
    }

    SearchPagedFlux search(String searchText, SearchOptions searchOptions, String querySourceAuthorization, Context context) {
        SearchRequest request = SearchAsyncClient.createSearchRequest(searchText, searchOptions);
        SearchFirstPageResponseWrapper firstPageResponseWrapper = new SearchFirstPageResponseWrapper();
        Function<String, Mono<SearchPagedResponse>> func = continuationToken -> this.search(request, (String)continuationToken, firstPageResponseWrapper, querySourceAuthorization, context);
        return new SearchPagedFlux(() -> (Mono)func.apply(null), func);
    }

    private Mono<SearchPagedResponse> search(SearchRequest request, String continuationToken, SearchFirstPageResponseWrapper firstPageResponseWrapper, String querySourceAuthorization, Context context) {
        if (continuationToken == null && firstPageResponseWrapper.getFirstPageResponse() != null) {
            return Mono.just((Object)((Object)firstPageResponseWrapper.getFirstPageResponse()));
        }
        SearchRequest requestToUse = continuationToken == null ? request : SearchContinuationToken.deserializeToken(this.serviceVersion.getVersion(), continuationToken);
        return this.restClient.getDocuments().searchPostWithResponseAsync(requestToUse, querySourceAuthorization, null, context).onErrorMap(MappingUtils::exceptionMapper).map(response -> {
            SearchDocumentsResult result = (SearchDocumentsResult)response.getValue();
            SearchPagedResponse page = new SearchPagedResponse((Response<List<SearchResult>>)new SimpleResponse(response, SearchAsyncClient.getSearchResults(result, this.serializer)), SearchAsyncClient.createContinuationToken(result, this.serviceVersion), result.getFacets(), result.getCount(), result.getCoverage(), result.getAnswers(), result.getSemanticPartialResponseReason(), result.getSemanticPartialResponseType());
            if (continuationToken == null) {
                firstPageResponseWrapper.setFirstPageResponse(page);
            }
            return page;
        });
    }

    static List<SearchResult> getSearchResults(SearchDocumentsResult result, JsonSerializer jsonSerializer) {
        return result.getResults().stream().map(searchResult -> SearchResultConverter.map(searchResult, (ObjectSerializer)jsonSerializer)).collect(Collectors.toList());
    }

    static String createContinuationToken(SearchDocumentsResult result, ServiceVersion serviceVersion) {
        return SearchContinuationToken.serializeToken(serviceVersion.getVersion(), result.getNextLink(), result.getNextPageParameters());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SuggestPagedFlux suggest(String searchText, String suggesterName) {
        return this.suggest(searchText, suggesterName, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SuggestPagedFlux suggest(String searchText, String suggesterName, SuggestOptions suggestOptions) {
        SuggestRequest suggestRequest = SearchAsyncClient.createSuggestRequest(searchText, suggesterName, Utility.ensureSuggestOptions(suggestOptions));
        return new SuggestPagedFlux(() -> FluxUtil.withContext(context -> this.suggest(suggestRequest, (Context)context)));
    }

    private Mono<SuggestPagedResponse> suggest(SuggestRequest suggestRequest, Context context) {
        return this.restClient.getDocuments().suggestPostWithResponseAsync(suggestRequest, null, context).onErrorMap(MappingUtils::exceptionMapper).map(response -> {
            SuggestDocumentsResult result = (SuggestDocumentsResult)response.getValue();
            return new SuggestPagedResponse((Response<List<SuggestResult>>)new SimpleResponse(response, SearchAsyncClient.getSuggestResults(result, this.serializer)), result.getCoverage());
        });
    }

    static List<SuggestResult> getSuggestResults(SuggestDocumentsResult result, JsonSerializer serializer) {
        return result.getResults().stream().map(suggestResult -> SuggestResultConverter.map(suggestResult, serializer)).collect(Collectors.toList());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public AutocompletePagedFlux autocomplete(String searchText, String suggesterName) {
        return this.autocomplete(searchText, suggesterName, null);
    }

    public AutocompletePagedFlux autocomplete(String searchText, String suggesterName, AutocompleteOptions autocompleteOptions) {
        AutocompleteRequest request = SearchAsyncClient.createAutoCompleteRequest(searchText, suggesterName, autocompleteOptions);
        return new AutocompletePagedFlux(() -> FluxUtil.withContext(context -> this.autocomplete(request, (Context)context)));
    }

    AutocompletePagedFlux autocomplete(String searchText, String suggesterName, AutocompleteOptions autocompleteOptions, Context context) {
        AutocompleteRequest request = SearchAsyncClient.createAutoCompleteRequest(searchText, suggesterName, autocompleteOptions);
        return new AutocompletePagedFlux(() -> this.autocomplete(request, context));
    }

    private Mono<AutocompletePagedResponse> autocomplete(AutocompleteRequest request, Context context) {
        return this.restClient.getDocuments().autocompletePostWithResponseAsync(request, null, context).onErrorMap(MappingUtils::exceptionMapper).map(response -> new AutocompletePagedResponse((SimpleResponse<AutocompleteResult>)new SimpleResponse(response, (Object)((AutocompleteResult)response.getValue()))));
    }

    static SearchRequest createSearchRequest(String searchText, SearchOptions options) {
        VectorSearchOptions vectorSearchOptions;
        SearchRequest request = new SearchRequest().setSearchText(searchText);
        if (options == null) {
            return request;
        }
        List<String> scoringParameters = options.getScoringParameters() == null ? null : options.getScoringParameters().stream().map(ScoringParameter::toString).collect(Collectors.toList());
        request.setQueryType(options.getQueryType()).setIncludeTotalResultCount(options.isTotalCountIncluded()).setFacets(options.getFacets()).setFilter(options.getFilter()).setHighlightFields(SearchAsyncClient.nullSafeStringJoin(options.getHighlightFields())).setHighlightPostTag(options.getHighlightPostTag()).setHighlightPreTag(options.getHighlightPreTag()).setMinimumCoverage(options.getMinimumCoverage()).setOrderBy(SearchAsyncClient.nullSafeStringJoin(options.getOrderBy())).setScoringParameters(scoringParameters).setScoringProfile(options.getScoringProfile()).setSearchFields(SearchAsyncClient.nullSafeStringJoin(options.getSearchFields())).setSearchMode(options.getSearchMode()).setScoringStatistics(options.getScoringStatistics()).setSessionId(options.getSessionId()).setSelect(SearchAsyncClient.nullSafeStringJoin(options.getSelect())).setSkip(options.getSkip()).setTop(options.getTop()).setQueryLanguage(options.getQueryLanguage()).setSpeller(options.getSpeller()).setDebug(options.getDebug());
        SemanticSearchOptions semanticSearchOptions = options.getSemanticSearchOptions();
        if (semanticSearchOptions != null) {
            Integer waitInMillis = semanticSearchOptions.getMaxWaitDuration() == null ? null : Integer.valueOf((int)semanticSearchOptions.getMaxWaitDuration().toMillis());
            request.setSemanticConfiguration(semanticSearchOptions.getSemanticConfigurationName()).setSemanticErrorHandling(semanticSearchOptions.getErrorMode()).setSemanticMaxWaitInMilliseconds(waitInMillis).setAnswers(SearchAsyncClient.createSearchRequestAnswers(semanticSearchOptions.getQueryAnswer())).setCaptions(SearchAsyncClient.createSearchRequestCaptions(semanticSearchOptions.getQueryCaption())).setSemanticQuery(semanticSearchOptions.getSemanticQuery()).setQueryRewrites(SearchAsyncClient.createQueryRewrites(semanticSearchOptions.getQueryRewrites()));
        }
        if ((vectorSearchOptions = options.getVectorSearchOptions()) != null) {
            request.setVectorFilterMode(vectorSearchOptions.getFilterMode()).setVectorQueries(vectorSearchOptions.getQueries());
        }
        return request;
    }

    static String createSearchRequestAnswers(QueryAnswer queryAnswer) {
        if (queryAnswer == null) {
            return null;
        }
        QueryAnswerType queryAnswerType = queryAnswer.getAnswerType();
        Integer answersCount = queryAnswer.getCount();
        Double answerThreshold = queryAnswer.getThreshold();
        Integer maxCharLength = queryAnswer.getMaxCharLength();
        if (queryAnswerType == null) {
            return null;
        }
        String answerType = queryAnswerType.toString();
        if (queryAnswerType == QueryAnswerType.NONE || answersCount == null && answerThreshold == null && maxCharLength == null) {
            return answerType;
        }
        StringBuilder answerStringBuilder = new StringBuilder(answerType).append('|');
        if (answersCount != null) {
            answerStringBuilder.append("count-").append(answersCount).append(",");
        }
        if (answerThreshold != null) {
            answerStringBuilder.append("threshold-").append(answerThreshold).append(",");
        }
        if (maxCharLength != null) {
            answerStringBuilder.append("maxCharLength-").append(maxCharLength).append(",");
        }
        if (answerStringBuilder.charAt(answerStringBuilder.length() - 1) == ',') {
            answerStringBuilder.deleteCharAt(answerStringBuilder.length() - 1);
        }
        return answerStringBuilder.toString();
    }

    static String createSearchRequestCaptions(QueryCaption queryCaption) {
        if (queryCaption == null) {
            return null;
        }
        QueryCaptionType queryCaptionType = queryCaption.getCaptionType();
        Boolean highlightEnabled = queryCaption.isHighlightEnabled();
        Integer maxCharLength = queryCaption.getMaxCharLength();
        if (queryCaptionType == null) {
            return null;
        }
        String queryCaptionTypeString = queryCaptionType.toString();
        if (queryCaptionType == QueryCaptionType.NONE || highlightEnabled == null && maxCharLength == null) {
            return queryCaptionTypeString;
        }
        StringBuilder captionStringBuilder = new StringBuilder(queryCaptionTypeString).append('|');
        if (highlightEnabled != null) {
            captionStringBuilder.append("highlight-").append(highlightEnabled).append(",");
        }
        if (maxCharLength != null) {
            captionStringBuilder.append("maxCharLength-").append(maxCharLength).append(",");
        }
        if (captionStringBuilder.charAt(captionStringBuilder.length() - 1) == ',') {
            captionStringBuilder.deleteCharAt(captionStringBuilder.length() - 1);
        }
        return captionStringBuilder.toString();
    }

    static String createQueryRewrites(QueryRewrites queryRewrites) {
        if (queryRewrites == null) {
            return null;
        }
        return queryRewrites.toString();
    }

    static SuggestRequest createSuggestRequest(String searchText, String suggesterName, SuggestOptions options) {
        SuggestRequest request = new SuggestRequest(searchText, suggesterName);
        if (options == null) {
            return request;
        }
        return request.setFilter(options.getFilter()).setUseFuzzyMatching(options.useFuzzyMatching()).setHighlightPostTag(options.getHighlightPostTag()).setHighlightPreTag(options.getHighlightPreTag()).setMinimumCoverage(options.getMinimumCoverage()).setOrderBy(SearchAsyncClient.nullSafeStringJoin(options.getOrderBy())).setSearchFields(SearchAsyncClient.nullSafeStringJoin(options.getSearchFields())).setSelect(SearchAsyncClient.nullSafeStringJoin(options.getSelect())).setTop(options.getTop());
    }

    static AutocompleteRequest createAutoCompleteRequest(String searchText, String suggesterName, AutocompleteOptions options) {
        AutocompleteRequest request = new AutocompleteRequest(searchText, suggesterName);
        if (options == null) {
            return request;
        }
        return request.setAutocompleteMode(options.getAutocompleteMode()).setFilter(options.getFilter()).setUseFuzzyMatching(options.useFuzzyMatching()).setHighlightPostTag(options.getHighlightPostTag()).setHighlightPreTag(options.getHighlightPreTag()).setMinimumCoverage(options.getMinimumCoverage()).setSearchFields(SearchAsyncClient.nullSafeStringJoin(options.getSearchFields())).setTop(options.getTop());
    }

    private static String nullSafeStringJoin(Iterable<? extends CharSequence> elements) {
        if (elements == null) {
            return null;
        }
        return String.join((CharSequence)",", elements);
    }

    static <T> IndexDocumentsBatch<T> buildIndexBatch(Iterable<T> documents, IndexActionType actionType) {
        ArrayList actions = new ArrayList();
        documents.forEach(d -> actions.add(new com.azure.search.documents.models.IndexAction().setActionType(actionType).setDocument(d)));
        return new IndexDocumentsBatch().addActions(actions);
    }
}

