/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.agents;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.client.traits.AzureKeyCredentialTrait;
import com.azure.core.client.traits.ConfigurationTrait;
import com.azure.core.client.traits.EndpointTrait;
import com.azure.core.client.traits.HttpTrait;
import com.azure.core.client.traits.TokenCredentialTrait;
import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JsonSerializer;
import com.azure.search.documents.SearchServiceVersion;
import com.azure.search.documents.agents.SearchKnowledgeAgentAsyncClient;
import com.azure.search.documents.agents.SearchKnowledgeAgentClient;
import com.azure.search.documents.implementation.util.Utility;
import com.azure.search.documents.models.SearchAudience;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={SearchKnowledgeAgentClient.class, SearchKnowledgeAgentAsyncClient.class})
public final class SearchKnowledgeAgentClientBuilder
implements AzureKeyCredentialTrait<SearchKnowledgeAgentClientBuilder>,
ConfigurationTrait<SearchKnowledgeAgentClientBuilder>,
EndpointTrait<SearchKnowledgeAgentClientBuilder>,
HttpTrait<SearchKnowledgeAgentClientBuilder>,
TokenCredentialTrait<SearchKnowledgeAgentClientBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(SearchKnowledgeAgentClientBuilder.class);
    private final List<HttpPipelinePolicy> perCallPolicies = new ArrayList<HttpPipelinePolicy>();
    private final List<HttpPipelinePolicy> perRetryPolicies = new ArrayList<HttpPipelinePolicy>();
    private AzureKeyCredential azureKeyCredential;
    private TokenCredential tokenCredential;
    private SearchAudience audience;
    private String endpoint;
    private String agentName;
    private SearchServiceVersion serviceVersion;
    private HttpClient httpClient;
    private HttpPipeline httpPipeline;
    private HttpLogOptions httpLogOptions;
    private ClientOptions clientOptions;
    private Configuration configuration;
    private RetryPolicy retryPolicy;
    private RetryOptions retryOptions;
    private JsonSerializer jsonSerializer;

    public SearchKnowledgeAgentClientBuilder endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public SearchKnowledgeAgentClientBuilder agentName(String agentName) {
        this.agentName = agentName;
        return this;
    }

    public SearchKnowledgeAgentClientBuilder serviceVersion(SearchServiceVersion apiVersion) {
        this.serviceVersion = apiVersion;
        return this;
    }

    public SearchKnowledgeAgentClientBuilder credential(AzureKeyCredential credential) {
        this.azureKeyCredential = credential;
        return this;
    }

    public SearchKnowledgeAgentClientBuilder credential(TokenCredential credential) {
        this.tokenCredential = credential;
        return this;
    }

    public SearchKnowledgeAgentClientBuilder audience(SearchAudience audience) {
        this.audience = audience;
        return this;
    }

    public SearchKnowledgeAgentClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.httpLogOptions = logOptions;
        return this;
    }

    public SearchKnowledgeAgentClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public SearchKnowledgeAgentClientBuilder addPolicy(HttpPipelinePolicy policy) {
        Objects.requireNonNull(policy, "'policy' cannot be null.");
        this.perCallPolicies.add(policy);
        return this;
    }

    public SearchKnowledgeAgentClientBuilder httpClient(HttpClient client) {
        this.httpClient = client;
        return this;
    }

    public SearchKnowledgeAgentClientBuilder pipeline(HttpPipeline httpPipeline) {
        this.httpPipeline = httpPipeline;
        return this;
    }

    public SearchKnowledgeAgentClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public SearchKnowledgeAgentClientBuilder retryOptions(RetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    public SearchKnowledgeAgentClient buildClient() {
        this.validateRequiredFields();
        SearchServiceVersion serviceVersion = this.serviceVersion != null ? this.serviceVersion : SearchServiceVersion.getLatest();
        HttpPipeline pipeline = this.httpPipeline != null ? this.httpPipeline : Utility.buildHttpPipeline(this.clientOptions, this.httpLogOptions, this.configuration, this.retryPolicy, this.retryOptions, this.azureKeyCredential, this.tokenCredential, this.audience, this.perCallPolicies, this.perRetryPolicies, this.httpClient, LOGGER);
        return new SearchKnowledgeAgentClient(this.endpoint, this.agentName, serviceVersion, pipeline);
    }

    public SearchKnowledgeAgentAsyncClient buildAsyncClient() {
        this.validateRequiredFields();
        SearchServiceVersion serviceVersion = this.serviceVersion != null ? this.serviceVersion : SearchServiceVersion.getLatest();
        HttpPipeline pipeline = this.httpPipeline != null ? this.httpPipeline : Utility.buildHttpPipeline(this.clientOptions, this.httpLogOptions, this.configuration, this.retryPolicy, this.retryOptions, this.azureKeyCredential, this.tokenCredential, this.audience, this.perCallPolicies, this.perRetryPolicies, this.httpClient, LOGGER);
        return new SearchKnowledgeAgentAsyncClient(this.endpoint, this.agentName, serviceVersion, pipeline);
    }

    private void validateRequiredFields() {
        Objects.requireNonNull(this.endpoint, "'endpoint' cannot be null.");
        Objects.requireNonNull(this.agentName, "'agentName' cannot be null.");
    }
}

