/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.agents.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class KnowledgeAgentIndexParams
implements JsonSerializable<KnowledgeAgentIndexParams> {
    private String indexName;
    private String filterAddOn;
    private Integer maxDocsForReranker;
    private Float rerankerThreshold;
    private Boolean includeReferenceSourceData;

    public String getIndexName() {
        return this.indexName;
    }

    public KnowledgeAgentIndexParams setIndexName(String indexName) {
        this.indexName = indexName;
        return this;
    }

    public String getFilterAddOn() {
        return this.filterAddOn;
    }

    public KnowledgeAgentIndexParams setFilterAddOn(String filterAddOn) {
        this.filterAddOn = filterAddOn;
        return this;
    }

    public Integer getMaxDocsForReranker() {
        return this.maxDocsForReranker;
    }

    public KnowledgeAgentIndexParams setMaxDocsForReranker(Integer maxDocsForReranker) {
        this.maxDocsForReranker = maxDocsForReranker;
        return this;
    }

    public Float getRerankerThreshold() {
        return this.rerankerThreshold;
    }

    public KnowledgeAgentIndexParams setRerankerThreshold(Float rerankerThreshold) {
        this.rerankerThreshold = rerankerThreshold;
        return this;
    }

    public Boolean isIncludeReferenceSourceData() {
        return this.includeReferenceSourceData;
    }

    public KnowledgeAgentIndexParams setIncludeReferenceSourceData(Boolean includeReferenceSourceData) {
        this.includeReferenceSourceData = includeReferenceSourceData;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("indexName", this.indexName);
        jsonWriter.writeStringField("filterAddOn", this.filterAddOn);
        jsonWriter.writeNumberField("maxDocsForReranker", (Number)this.maxDocsForReranker);
        jsonWriter.writeNumberField("rerankerThreshold", (Number)this.rerankerThreshold);
        jsonWriter.writeBooleanField("includeReferenceSourceData", this.includeReferenceSourceData);
        return jsonWriter.writeEndObject();
    }

    public static KnowledgeAgentIndexParams fromJson(JsonReader jsonReader) throws IOException {
        return (KnowledgeAgentIndexParams)jsonReader.readObject(reader -> {
            KnowledgeAgentIndexParams deserializedKnowledgeAgentIndexParams = new KnowledgeAgentIndexParams();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("indexName".equals(fieldName)) {
                    deserializedKnowledgeAgentIndexParams.indexName = reader.getString();
                    continue;
                }
                if ("filterAddOn".equals(fieldName)) {
                    deserializedKnowledgeAgentIndexParams.filterAddOn = reader.getString();
                    continue;
                }
                if ("maxDocsForReranker".equals(fieldName)) {
                    deserializedKnowledgeAgentIndexParams.maxDocsForReranker = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("rerankerThreshold".equals(fieldName)) {
                    deserializedKnowledgeAgentIndexParams.rerankerThreshold = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("includeReferenceSourceData".equals(fieldName)) {
                    deserializedKnowledgeAgentIndexParams.includeReferenceSourceData = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKnowledgeAgentIndexParams;
        });
    }
}

