/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.agents.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.agents.models.KnowledgeAgentAzureBlobReference;
import com.azure.search.documents.agents.models.KnowledgeAgentSearchIndexReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public class KnowledgeAgentReference
implements JsonSerializable<KnowledgeAgentReference> {
    private String type = "KnowledgeAgentReference";
    private final String id;
    private final int activitySource;
    private Map<String, Object> sourceData;
    private Float rerankerScore;

    public KnowledgeAgentReference(String id, int activitySource) {
        this.id = id;
        this.activitySource = activitySource;
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public int getActivitySource() {
        return this.activitySource;
    }

    public Map<String, Object> getSourceData() {
        return this.sourceData;
    }

    public KnowledgeAgentReference setSourceData(Map<String, Object> sourceData) {
        this.sourceData = sourceData;
        return this;
    }

    public Float getRerankerScore() {
        return this.rerankerScore;
    }

    public KnowledgeAgentReference setRerankerScore(Float rerankerScore) {
        this.rerankerScore = rerankerScore;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeIntField("activitySource", this.activitySource);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeMapField("sourceData", this.sourceData, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeNumberField("rerankerScore", (Number)this.rerankerScore);
        return jsonWriter.writeEndObject();
    }

    public static KnowledgeAgentReference fromJson(JsonReader jsonReader) throws IOException {
        return (KnowledgeAgentReference)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                KnowledgeAgentReference knowledgeAgentReference;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("searchIndex".equals(discriminatorValue)) {
                    knowledgeAgentReference = KnowledgeAgentSearchIndexReference.fromJson(readerToUse.reset());
                    return knowledgeAgentReference;
                }
                if ("azureBlob".equals(discriminatorValue)) {
                    knowledgeAgentReference = KnowledgeAgentAzureBlobReference.fromJson(readerToUse.reset());
                    return knowledgeAgentReference;
                }
                knowledgeAgentReference = KnowledgeAgentReference.fromJsonKnownDiscriminator(readerToUse.reset());
                return knowledgeAgentReference;
            }
        });
    }

    static KnowledgeAgentReference fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (KnowledgeAgentReference)jsonReader.readObject(reader -> {
            boolean idFound = false;
            String id = null;
            boolean activitySourceFound = false;
            int activitySource = 0;
            String type = null;
            Map sourceData = null;
            Float rerankerScore = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    idFound = true;
                    continue;
                }
                if ("activitySource".equals(fieldName)) {
                    activitySource = reader.getInt();
                    activitySourceFound = true;
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                if ("sourceData".equals(fieldName)) {
                    sourceData = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("rerankerScore".equals(fieldName)) {
                    rerankerScore = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                reader.skipChildren();
            }
            if (idFound && activitySourceFound) {
                KnowledgeAgentReference deserializedKnowledgeAgentReference = new KnowledgeAgentReference(id, activitySource);
                deserializedKnowledgeAgentReference.type = type;
                deserializedKnowledgeAgentReference.sourceData = sourceData;
                deserializedKnowledgeAgentReference.rerankerScore = rerankerScore;
                return deserializedKnowledgeAgentReference;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!idFound) {
                missingProperties.add("id");
            }
            if (!activitySourceFound) {
                missingProperties.add("activitySource");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

