/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.agents.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.agents.models.KnowledgeAgentMessage;
import com.azure.search.documents.agents.models.KnowledgeSourceParams;
import java.io.IOException;
import java.util.List;

public final class KnowledgeAgentRetrievalRequest
implements JsonSerializable<KnowledgeAgentRetrievalRequest> {
    private final List<KnowledgeAgentMessage> messages;
    private List<KnowledgeSourceParams> knowledgeSourceParams;

    public KnowledgeAgentRetrievalRequest(List<KnowledgeAgentMessage> messages) {
        this.messages = messages;
    }

    public List<KnowledgeAgentMessage> getMessages() {
        return this.messages;
    }

    public List<KnowledgeSourceParams> getKnowledgeSourceParams() {
        return this.knowledgeSourceParams;
    }

    public KnowledgeAgentRetrievalRequest setKnowledgeSourceParams(List<KnowledgeSourceParams> knowledgeSourceParams) {
        this.knowledgeSourceParams = knowledgeSourceParams;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("messages", this.messages, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("knowledgeSourceParams", this.knowledgeSourceParams, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static KnowledgeAgentRetrievalRequest fromJson(JsonReader jsonReader) throws IOException {
        return (KnowledgeAgentRetrievalRequest)jsonReader.readObject(reader -> {
            boolean messagesFound = false;
            List messages = null;
            List knowledgeSourceParams = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("messages".equals(fieldName)) {
                    messages = reader.readArray(reader1 -> KnowledgeAgentMessage.fromJson(reader1));
                    messagesFound = true;
                    continue;
                }
                if ("knowledgeSourceParams".equals(fieldName)) {
                    knowledgeSourceParams = reader.readArray(reader1 -> KnowledgeSourceParams.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            if (messagesFound) {
                KnowledgeAgentRetrievalRequest deserializedKnowledgeAgentRetrievalRequest = new KnowledgeAgentRetrievalRequest(messages);
                deserializedKnowledgeAgentRetrievalRequest.knowledgeSourceParams = knowledgeSourceParams;
                return deserializedKnowledgeAgentRetrievalRequest;
            }
            throw new IllegalStateException("Missing required property: messages");
        });
    }
}

