/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.agents.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.agents.models.KnowledgeAgentActivityRecord;
import com.azure.search.documents.agents.models.KnowledgeAgentSearchActivityRecordQuery;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class KnowledgeAgentSearchActivityRecord
extends KnowledgeAgentActivityRecord {
    private String type = "AzureSearchQuery";
    private String targetIndex;
    private KnowledgeAgentSearchActivityRecordQuery query;
    private OffsetDateTime queryTime;
    private Integer count;
    private Integer elapsedMs;

    public KnowledgeAgentSearchActivityRecord(int id) {
        super(id);
    }

    @Override
    public String getType() {
        return this.type;
    }

    public String getTargetIndex() {
        return this.targetIndex;
    }

    public KnowledgeAgentSearchActivityRecord setTargetIndex(String targetIndex) {
        this.targetIndex = targetIndex;
        return this;
    }

    public KnowledgeAgentSearchActivityRecordQuery getQuery() {
        return this.query;
    }

    public KnowledgeAgentSearchActivityRecord setQuery(KnowledgeAgentSearchActivityRecordQuery query) {
        this.query = query;
        return this;
    }

    public OffsetDateTime getQueryTime() {
        return this.queryTime;
    }

    public KnowledgeAgentSearchActivityRecord setQueryTime(OffsetDateTime queryTime) {
        this.queryTime = queryTime;
        return this;
    }

    public Integer getCount() {
        return this.count;
    }

    public KnowledgeAgentSearchActivityRecord setCount(Integer count) {
        this.count = count;
        return this;
    }

    @Override
    public Integer getElapsedMs() {
        return this.elapsedMs;
    }

    @Override
    public KnowledgeAgentSearchActivityRecord setElapsedMs(Integer elapsedMs) {
        this.elapsedMs = elapsedMs;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("id", this.getId());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("targetIndex", this.targetIndex);
        jsonWriter.writeJsonField("query", (JsonSerializable)this.query);
        jsonWriter.writeStringField("queryTime", this.queryTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.queryTime));
        jsonWriter.writeNumberField("count", (Number)this.count);
        jsonWriter.writeNumberField("elapsedMs", (Number)this.elapsedMs);
        return jsonWriter.writeEndObject();
    }

    public static KnowledgeAgentSearchActivityRecord fromJson(JsonReader jsonReader) throws IOException {
        return (KnowledgeAgentSearchActivityRecord)jsonReader.readObject(reader -> {
            boolean idFound = false;
            int id = 0;
            String type = "AzureSearchQuery";
            String targetIndex = null;
            KnowledgeAgentSearchActivityRecordQuery query = null;
            OffsetDateTime queryTime = null;
            Integer count = null;
            Integer elapsedMs = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getInt();
                    idFound = true;
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                if ("targetIndex".equals(fieldName)) {
                    targetIndex = reader.getString();
                    continue;
                }
                if ("query".equals(fieldName)) {
                    query = KnowledgeAgentSearchActivityRecordQuery.fromJson(reader);
                    continue;
                }
                if ("queryTime".equals(fieldName)) {
                    queryTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("count".equals(fieldName)) {
                    count = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("elapsedMs".equals(fieldName)) {
                    elapsedMs = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            if (idFound) {
                KnowledgeAgentSearchActivityRecord deserializedKnowledgeAgentSearchActivityRecord = new KnowledgeAgentSearchActivityRecord(id);
                deserializedKnowledgeAgentSearchActivityRecord.type = type;
                deserializedKnowledgeAgentSearchActivityRecord.targetIndex = targetIndex;
                deserializedKnowledgeAgentSearchActivityRecord.query = query;
                deserializedKnowledgeAgentSearchActivityRecord.queryTime = queryTime;
                deserializedKnowledgeAgentSearchActivityRecord.count = count;
                deserializedKnowledgeAgentSearchActivityRecord.elapsedMs = elapsedMs;
                return deserializedKnowledgeAgentSearchActivityRecord;
            }
            throw new IllegalStateException("Missing required property: id");
        });
    }
}

