/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.agents.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.agents.models.KnowledgeAgentRetrievalActivityRecord;
import com.azure.search.documents.agents.models.KnowledgeAgentSearchIndexActivityArguments;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class KnowledgeAgentSearchIndexActivityRecord
extends KnowledgeAgentRetrievalActivityRecord {
    private String type = "searchIndex";
    private KnowledgeAgentSearchIndexActivityArguments searchIndexArguments;

    public KnowledgeAgentSearchIndexActivityRecord(int id) {
        super(id);
    }

    @Override
    public String getType() {
        return this.type;
    }

    public KnowledgeAgentSearchIndexActivityArguments getSearchIndexArguments() {
        return this.searchIndexArguments;
    }

    public KnowledgeAgentSearchIndexActivityRecord setSearchIndexArguments(KnowledgeAgentSearchIndexActivityArguments searchIndexArguments) {
        this.searchIndexArguments = searchIndexArguments;
        return this;
    }

    @Override
    public KnowledgeAgentSearchIndexActivityRecord setKnowledgeSourceName(String knowledgeSourceName) {
        super.setKnowledgeSourceName(knowledgeSourceName);
        return this;
    }

    @Override
    public KnowledgeAgentSearchIndexActivityRecord setQueryTime(OffsetDateTime queryTime) {
        super.setQueryTime(queryTime);
        return this;
    }

    @Override
    public KnowledgeAgentSearchIndexActivityRecord setCount(Integer count) {
        super.setCount(count);
        return this;
    }

    @Override
    public KnowledgeAgentSearchIndexActivityRecord setElapsedMs(Integer elapsedMs) {
        super.setElapsedMs(elapsedMs);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("id", this.getId());
        jsonWriter.writeNumberField("elapsedMs", (Number)this.getElapsedMs());
        jsonWriter.writeStringField("knowledgeSourceName", this.getKnowledgeSourceName());
        jsonWriter.writeStringField("queryTime", this.getQueryTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.getQueryTime()));
        jsonWriter.writeNumberField("count", (Number)this.getCount());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("searchIndexArguments", (JsonSerializable)this.searchIndexArguments);
        return jsonWriter.writeEndObject();
    }

    public static KnowledgeAgentSearchIndexActivityRecord fromJson(JsonReader jsonReader) throws IOException {
        return (KnowledgeAgentSearchIndexActivityRecord)jsonReader.readObject(reader -> {
            boolean idFound = false;
            int id = 0;
            Integer elapsedMs = null;
            String knowledgeSourceName = null;
            OffsetDateTime queryTime = null;
            Integer count = null;
            String type = "searchIndex";
            KnowledgeAgentSearchIndexActivityArguments searchIndexArguments = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getInt();
                    idFound = true;
                    continue;
                }
                if ("elapsedMs".equals(fieldName)) {
                    elapsedMs = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("knowledgeSourceName".equals(fieldName)) {
                    knowledgeSourceName = reader.getString();
                    continue;
                }
                if ("queryTime".equals(fieldName)) {
                    queryTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("count".equals(fieldName)) {
                    count = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                if ("searchIndexArguments".equals(fieldName)) {
                    searchIndexArguments = KnowledgeAgentSearchIndexActivityArguments.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            if (idFound) {
                KnowledgeAgentSearchIndexActivityRecord deserializedKnowledgeAgentSearchIndexActivityRecord = new KnowledgeAgentSearchIndexActivityRecord(id);
                deserializedKnowledgeAgentSearchIndexActivityRecord.setElapsedMs(elapsedMs);
                deserializedKnowledgeAgentSearchIndexActivityRecord.setKnowledgeSourceName(knowledgeSourceName);
                deserializedKnowledgeAgentSearchIndexActivityRecord.setQueryTime(queryTime);
                deserializedKnowledgeAgentSearchIndexActivityRecord.setCount(count);
                deserializedKnowledgeAgentSearchIndexActivityRecord.type = type;
                deserializedKnowledgeAgentSearchIndexActivityRecord.searchIndexArguments = searchIndexArguments;
                return deserializedKnowledgeAgentSearchIndexActivityRecord;
            }
            throw new IllegalStateException("Missing required property: id");
        });
    }
}

