/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.agents.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.agents.models.KnowledgeAgentReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public final class KnowledgeAgentSearchIndexReference
extends KnowledgeAgentReference {
    private String type = "searchIndex";
    private String docKey;

    public KnowledgeAgentSearchIndexReference(String id, int activitySource) {
        super(id, activitySource);
    }

    @Override
    public String getType() {
        return this.type;
    }

    public String getDocKey() {
        return this.docKey;
    }

    public KnowledgeAgentSearchIndexReference setDocKey(String docKey) {
        this.docKey = docKey;
        return this;
    }

    @Override
    public KnowledgeAgentSearchIndexReference setSourceData(Map<String, Object> sourceData) {
        super.setSourceData(sourceData);
        return this;
    }

    @Override
    public KnowledgeAgentSearchIndexReference setRerankerScore(Float rerankerScore) {
        super.setRerankerScore(rerankerScore);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.getId());
        jsonWriter.writeIntField("activitySource", this.getActivitySource());
        jsonWriter.writeMapField("sourceData", this.getSourceData(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeNumberField("rerankerScore", (Number)this.getRerankerScore());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("docKey", this.docKey);
        return jsonWriter.writeEndObject();
    }

    public static KnowledgeAgentSearchIndexReference fromJson(JsonReader jsonReader) throws IOException {
        return (KnowledgeAgentSearchIndexReference)jsonReader.readObject(reader -> {
            boolean idFound = false;
            String id = null;
            boolean activitySourceFound = false;
            int activitySource = 0;
            Map sourceData = null;
            Float rerankerScore = null;
            String type = "searchIndex";
            String docKey = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    idFound = true;
                    continue;
                }
                if ("activitySource".equals(fieldName)) {
                    activitySource = reader.getInt();
                    activitySourceFound = true;
                    continue;
                }
                if ("sourceData".equals(fieldName)) {
                    sourceData = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("rerankerScore".equals(fieldName)) {
                    rerankerScore = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                if ("docKey".equals(fieldName)) {
                    docKey = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (idFound && activitySourceFound) {
                KnowledgeAgentSearchIndexReference deserializedKnowledgeAgentSearchIndexReference = new KnowledgeAgentSearchIndexReference(id, activitySource);
                deserializedKnowledgeAgentSearchIndexReference.setSourceData(sourceData);
                deserializedKnowledgeAgentSearchIndexReference.setRerankerScore(rerankerScore);
                deserializedKnowledgeAgentSearchIndexReference.type = type;
                deserializedKnowledgeAgentSearchIndexReference.docKey = docKey;
                return deserializedKnowledgeAgentSearchIndexReference;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!idFound) {
                missingProperties.add("id");
            }
            if (!activitySourceFound) {
                missingProperties.add("activitySource");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

