/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.agents.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.agents.models.KnowledgeSourceKind;
import com.azure.search.documents.agents.models.SearchIndexKnowledgeSourceParams;
import java.io.IOException;

public class KnowledgeSourceParams
implements JsonSerializable<KnowledgeSourceParams> {
    private KnowledgeSourceKind kind = KnowledgeSourceKind.fromString("KnowledgeSourceParams");
    private final String knowledgeSourceName;

    public KnowledgeSourceParams(String knowledgeSourceName) {
        this.knowledgeSourceName = knowledgeSourceName;
    }

    public KnowledgeSourceKind getKind() {
        return this.kind;
    }

    public String getKnowledgeSourceName() {
        return this.knowledgeSourceName;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("knowledgeSourceName", this.knowledgeSourceName);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    public static KnowledgeSourceParams fromJson(JsonReader jsonReader) throws IOException {
        return (KnowledgeSourceParams)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                KnowledgeSourceParams knowledgeSourceParams;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("kind".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("searchIndex".equals(discriminatorValue)) {
                    knowledgeSourceParams = SearchIndexKnowledgeSourceParams.fromJson(readerToUse.reset());
                    return knowledgeSourceParams;
                }
                knowledgeSourceParams = KnowledgeSourceParams.fromJsonKnownDiscriminator(readerToUse.reset());
                return knowledgeSourceParams;
            }
        });
    }

    static KnowledgeSourceParams fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (KnowledgeSourceParams)jsonReader.readObject(reader -> {
            boolean knowledgeSourceNameFound = false;
            String knowledgeSourceName = null;
            KnowledgeSourceKind kind = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("knowledgeSourceName".equals(fieldName)) {
                    knowledgeSourceName = reader.getString();
                    knowledgeSourceNameFound = true;
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    kind = KnowledgeSourceKind.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            if (knowledgeSourceNameFound) {
                KnowledgeSourceParams deserializedKnowledgeSourceParams = new KnowledgeSourceParams(knowledgeSourceName);
                deserializedKnowledgeSourceParams.kind = kind;
                return deserializedKnowledgeSourceParams;
            }
            throw new IllegalStateException("Missing required property: knowledgeSourceName");
        });
    }
}

