/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.implementation.models.SearchRequest;
import com.azure.search.documents.implementation.models.SearchResult;
import com.azure.search.documents.models.DebugInfo;
import com.azure.search.documents.models.FacetResult;
import com.azure.search.documents.models.QueryAnswerResult;
import com.azure.search.documents.models.SemanticErrorReason;
import com.azure.search.documents.models.SemanticQueryRewritesResultType;
import com.azure.search.documents.models.SemanticSearchResultsType;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class SearchDocumentsResult
implements JsonSerializable<SearchDocumentsResult> {
    private Long count;
    private Double coverage;
    private Map<String, List<FacetResult>> facets;
    private List<QueryAnswerResult> answers;
    private DebugInfo debugInfo;
    private SearchRequest nextPageParameters;
    private final List<SearchResult> results;
    private String nextLink;
    private SemanticErrorReason semanticPartialResponseReason;
    private SemanticSearchResultsType semanticPartialResponseType;
    private SemanticQueryRewritesResultType semanticQueryRewritesResultType;

    public SearchDocumentsResult(List<SearchResult> results) {
        this.results = results;
    }

    public Long getCount() {
        return this.count;
    }

    public Double getCoverage() {
        return this.coverage;
    }

    public Map<String, List<FacetResult>> getFacets() {
        return this.facets;
    }

    public List<QueryAnswerResult> getAnswers() {
        return this.answers;
    }

    public DebugInfo getDebugInfo() {
        return this.debugInfo;
    }

    public SearchRequest getNextPageParameters() {
        return this.nextPageParameters;
    }

    public List<SearchResult> getResults() {
        return this.results;
    }

    public String getNextLink() {
        return this.nextLink;
    }

    public SemanticErrorReason getSemanticPartialResponseReason() {
        return this.semanticPartialResponseReason;
    }

    public SemanticSearchResultsType getSemanticPartialResponseType() {
        return this.semanticPartialResponseType;
    }

    public SemanticQueryRewritesResultType getSemanticQueryRewritesResultType() {
        return this.semanticQueryRewritesResultType;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static SearchDocumentsResult fromJson(JsonReader jsonReader) throws IOException {
        return (SearchDocumentsResult)jsonReader.readObject(reader -> {
            boolean resultsFound = false;
            List results = null;
            Long count = null;
            Double coverage = null;
            Map facets = null;
            List answers = null;
            DebugInfo debugInfo = null;
            SearchRequest nextPageParameters = null;
            String nextLink = null;
            SemanticErrorReason semanticPartialResponseReason = null;
            SemanticSearchResultsType semanticPartialResponseType = null;
            SemanticQueryRewritesResultType semanticQueryRewritesResultType = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    results = reader.readArray(reader1 -> SearchResult.fromJson(reader1));
                    resultsFound = true;
                    continue;
                }
                if ("@odata.count".equals(fieldName)) {
                    count = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("@search.coverage".equals(fieldName)) {
                    coverage = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("@search.facets".equals(fieldName)) {
                    facets = reader.readMap(reader1 -> reader1.readArray(reader2 -> FacetResult.fromJson(reader2)));
                    continue;
                }
                if ("@search.answers".equals(fieldName)) {
                    answers = reader.readArray(reader1 -> QueryAnswerResult.fromJson(reader1));
                    continue;
                }
                if ("@search.debug".equals(fieldName)) {
                    debugInfo = DebugInfo.fromJson(reader);
                    continue;
                }
                if ("@search.nextPageParameters".equals(fieldName)) {
                    nextPageParameters = SearchRequest.fromJson(reader);
                    continue;
                }
                if ("@odata.nextLink".equals(fieldName)) {
                    nextLink = reader.getString();
                    continue;
                }
                if ("@search.semanticPartialResponseReason".equals(fieldName)) {
                    semanticPartialResponseReason = SemanticErrorReason.fromString(reader.getString());
                    continue;
                }
                if ("@search.semanticPartialResponseType".equals(fieldName)) {
                    semanticPartialResponseType = SemanticSearchResultsType.fromString(reader.getString());
                    continue;
                }
                if ("@search.semanticQueryRewritesResultType".equals(fieldName)) {
                    semanticQueryRewritesResultType = SemanticQueryRewritesResultType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            if (resultsFound) {
                SearchDocumentsResult deserializedSearchDocumentsResult = new SearchDocumentsResult(results);
                deserializedSearchDocumentsResult.count = count;
                deserializedSearchDocumentsResult.coverage = coverage;
                deserializedSearchDocumentsResult.facets = facets;
                deserializedSearchDocumentsResult.answers = answers;
                deserializedSearchDocumentsResult.debugInfo = debugInfo;
                deserializedSearchDocumentsResult.nextPageParameters = nextPageParameters;
                deserializedSearchDocumentsResult.nextLink = nextLink;
                deserializedSearchDocumentsResult.semanticPartialResponseReason = semanticPartialResponseReason;
                deserializedSearchDocumentsResult.semanticPartialResponseType = semanticPartialResponseType;
                deserializedSearchDocumentsResult.semanticQueryRewritesResultType = semanticQueryRewritesResultType;
                return deserializedSearchDocumentsResult;
            }
            throw new IllegalStateException("Missing required property: value");
        });
    }
}

